package com.cusc.component.uid.service.impl;

import java.sql.SQLException;

import javax.annotation.PostConstruct;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.cusc.component.uid.config.SegmentConfig;
import com.cusc.component.uid.core.Result;
import com.cusc.component.uid.dao.IDAllocDao;
import com.cusc.component.uid.dao.impl.IDAllocDaoImpl;
import com.cusc.component.uid.exception.InitException;
import com.cusc.component.uid.service.IDGen;
import com.cusc.component.uid.util.RedisCenter;

@Service("SegmentService")
public class SegmentService {

	private Logger logger = LoggerFactory.getLogger(SegmentService.class);
	//private static final int RE_TIMES = 3;

	IDGen idGen;
	@Autowired
	SegmentConfig segmentConfig;
	@Autowired
	RedisCenter redisService;

	@PostConstruct
	public void init() throws SQLException, InitException {
		logger.info("分段模式是否开启:{}", segmentConfig.isEnable());
		if (segmentConfig.isEnable()) {
			// Config Dao
			IDAllocDao dao = new IDAllocDaoImpl(redisService);

			// Config ID Gen
			idGen = new SegmentIDGenImpl();
			((SegmentIDGenImpl) idGen).setDao(dao);
			if (idGen.init()) {
				logger.info("Segment Service Init Successfully");
			} else {
				throw new InitException("Segment Service Init Fail");
			}
		} else {
			idGen = new ZeroIDGen();
			logger.info("Zero ID Gen Service Init Successfully");
		}
	}

	public Result getId(String key) {
		return idGen.get(key);
	}
	
	public Result getContinuId(String key) {
		return idGen.getContinu(key);
	}
	
	/**
	 * 
	 * 按日期生成业务编码，返回编码为：{prefixCode}+{日期}+{连续编码}
	 * 
	 * @param domainKey  必填，业务接入申请的key
	 * @param prefixCode 可选，业务编码前缀
	 * @param dayFormat  可选，日期格式，默认:yyyyMMdd
	 * @param codeFormat 可选，连续编码格式，默认：000000
	 * @return 返回格式化业务编码
	 */
	public Result getDayContinueCode(String domainKey, String prefixCode, String dayFormat, String codeFormat) {
		return idGen.getDayContinueCode(domainKey, prefixCode, dayFormat, codeFormat);
	}

	public SegmentIDGenImpl getIdGen() {
		if (idGen instanceof SegmentIDGenImpl) {
			return (SegmentIDGenImpl) idGen;
		}
		return null;
	}
}
