package com.cusc.component.uid.dao.impl;

import java.util.List;
import java.util.UUID;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.alibaba.fastjson.JSONObject;
import com.cusc.component.uid.core.LeafAlloc;
import com.cusc.component.uid.core.UidConstants;
import com.cusc.component.uid.dao.IDAllocDao;
import com.cusc.component.uid.util.RedisCenter;

public class IDAllocDaoImpl implements IDAllocDao {

	private static final Logger logger = LoggerFactory.getLogger(IDAllocDaoImpl.class);

	private static Integer LOCK_MILLS = 5000;// 持有时间ms

	private static Integer RETRY_TIMES = 50;// 重试次数

	private static Integer SLEEP_THREAD = 100;// 等待时间ms

	RedisCenter redisService;

	public IDAllocDaoImpl(RedisCenter redisService) {
		this.redisService = redisService;
	}

	@Override
	public LeafAlloc updateMaxIdAndGet(String tag) {

		try {
			String res = redisService.hget(UidConstants.UID_R_KEY, tag);
			LeafAlloc leafs = JSONObject.parseObject(res, LeafAlloc.class);
			leafs.setMaxId(leafs.getMaxId() + leafs.getStep());
			String uuid = UUID.randomUUID().toString().replace("-", "");
			if (redisService.dislock(UidConstants.LOCK_KEY + ":" + leafs.getKey(), uuid, LOCK_MILLS, SLEEP_THREAD,
					RETRY_TIMES)) {
				redisService.hset(UidConstants.UID_R_KEY, leafs.getKey(), JSONObject.toJSONString(leafs));
				redisService.unlock(UidConstants.LOCK_KEY + ":" + leafs.getKey(), uuid);
			}
			return leafs;
		} catch (Exception e) {
			logger.error("updateMaxIdAndGet failed,exception:{}", e.toString());
			return null;
		}
	}

	@Override
	public LeafAlloc updateMaxIdByCustomStep(LeafAlloc leafAlloc) {
		try {
			String res = redisService.hget(UidConstants.UID_R_KEY, leafAlloc.getKey());
			LeafAlloc leafs = JSONObject.parseObject(res, LeafAlloc.class);
			leafs.setMaxId(leafs.getMaxId() + leafAlloc.getStep());
			String uuid = UUID.randomUUID().toString().replace("-", "");
			if (redisService.dislock(UidConstants.LOCK_KEY + ":" + leafs.getKey(), uuid, LOCK_MILLS, SLEEP_THREAD,
					RETRY_TIMES)) {
				redisService.hset(UidConstants.UID_R_KEY, leafAlloc.getKey(), JSONObject.toJSONString(leafs));
				redisService.unlock(UidConstants.LOCK_KEY + ":" + leafs.getKey(), uuid);
			}
			return leafs;
		} catch (Exception e) {
			logger.error("updateMaxIdAndGet failed,exception:{}", e.toString());
			return null;
		}
	}

	@Override
	public List<String> getAllKeys() {
		return redisService.queryKey(UidConstants.UID_R_KEY);
	}

	@Override
	public Long incrKey(String key) {
		try {
			return redisService.incr(key);
		} catch (Exception e) {
			logger.error("获取ID失败，key: {},exception:", key, e);
			return null;
		}
	}
}
