package com.cusc.component.uid.dao;

import java.util.List;

import com.cusc.component.uid.core.LeafAlloc;

public interface IDAllocDao {
	/*
	 * List<LeafAlloc> getAllLeafAllocs(); LeafAlloc
	 * updateMaxIdAndGetLeafAlloc(String tag); LeafAlloc
	 * updateMaxIdByCustomStepAndGetLeafAlloc(LeafAlloc leafAlloc); List<String>
	 * getAllTags();
	 */

	/**
	 * 获取所有redis库中key-leafalloc
	 * 
	 * @return
	 */
	// List<LeafAlloc> getAllLeafs();
	/**
	 * 根据key更新max_id，并返回实体(此中步长为原对象中步长)
	 * 
	 * @param tag
	 * @return
	 */
	LeafAlloc updateMaxIdAndGet(String tag);

	/**
	 * 根据传过来的实体更新max_id，并返回实体(此中步长为传过来对象中的步长)
	 * 
	 * @param leafAlloc
	 * @return
	 */
	LeafAlloc updateMaxIdByCustomStep(LeafAlloc leafAlloc);

	/**
	 * 获取所有tags
	 * 
	 * @return
	 */
	List<String> getAllKeys();

	/**
	 * 自增加1
	 * 
	 * @param key
	 * @return
	 */
	Long incrKey(String key);
}
