package com.cusc.component.uid.core;

/**
 * 
 * @ClassName: ResultGenerator 
 * @Description: 响应结果生成工具
 * @author handx handxings@gmail.com 
 * @date 2019年5月28日 上午11:03:16 
 *
 */
public class ResultGenerator {
    private static final String DEFAULT_SUCCESS_MESSAGE = "SUCCESS";
    
    private static final long ID_OUT_MAX = -1l;

    public static Result genSuccessResult() {
        return new Result()
                .setCode(ResultCode.SUCCESS)
                .setMessage(DEFAULT_SUCCESS_MESSAGE);
    }

    public static Result genSuccessResult(Object data) {
        return new Result()
                .setCode(ResultCode.SUCCESS)
                .setMessage(DEFAULT_SUCCESS_MESSAGE)
                .setData(data);
    }

    public static Result genFailResult(String message) {
        return new Result()
                .setCode(ResultCode.FAIL)
                .setMessage(message);
    }
    
    public static Result genFailResult(ResultCode code,String message) {
    	return new Result()
    			.setCode(code)
    			.setMessage(message);
    }

	public static Result idOutMax(String message) {
		return new Result().setCode(ResultCode.ID_OUT_MAX).setData(ID_OUT_MAX).setMessage(message);
	}
}
