package com.cusc.component.uid.core;

/**
 * 响应码枚举，参考HTTP状态码的语义
 */
public enum ResultCode {

	SUCCESS(200), // 成功
	FAIL(400), // 失败
	ID_IDCACHE_INIT_FALSE(10001), // IDCache未初始化成功时的异常码
	ID_KEY_NOT_EXISTS(20001), // key不存在时的异常码
	ID_TWO_SEGMENTS_ARE_NULL(30001), // SegmentBuffer中的两个Segment均未从DB中装载时的异常码
	PARAMETER_EXCEPTION(40001),
	TIME_CALLBACK_EXCEPTION(50001),// 时间回拨异常
	THREAD_INTERRUPTED_EXCEPTION(60001),//线程等待中断异常
	ID_OUT_MAX(70001)//ID超出指定长度
	;

	private final int code;

	ResultCode(int code) {
		this.code = code;
	}

	public int code() {
		return code;
	}
}
