package com.cusc.component.uid.core;

import java.io.Serializable;

import com.alibaba.fastjson.JSON;

/** 
 * @ClassName: Result 
 * @Description: 统一API响应结果封装
 * @author handx handxings@gmail.com 
 * @date 2019年5月28日 上午11:02:21 
 *
 */
public class Result implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = -2328687306146734668L;
	private int code;
	private String message;
	private Object data;

	public Result setCode(ResultCode resultCode) {
		this.code = resultCode.code();
		return this;
	}

	public int getCode() {
		return code;
	}

	public String getMessage() {
		return message;
	}

	public Result setMessage(String message) {
		this.message = message;
		return this;
	}

	public Object getData() {
		return data;
	}

	public Result setData(Object data) {
		this.data = data;
		return this;
	}

	public Result setIntCode(int resultCode) {
		this.code = resultCode;
		return this;
	}

	@Override
	public String toString() {
		return JSON.toJSONString(this);
	}
}
