package com.cusc.component.uid.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

import com.cusc.component.uid.core.UidConstants;

/** 
 * @Description: 
 * @author xu_fxiang@163.com
 * @date 2019年10月23日 下午3:23:45
 */

@Configuration("redisConfiguration")
public class RedisConfiguration {
	
	@Value("${leaf.redis.database:0}")
	private int database;
	@Value("${leaf.redis.host-name:6379}")
	private String hostname;
	@Value("${leaf.redis.port:6379}")
	private int port;
	@Value("${leaf.redis.password}")
	private String password;
	@Value("${leaf.redis.timeout:2000}")
	private int timeout;
	@Value("${leaf.redis.pool.max-idle:16}")
	private int maxidle;
	@Value("${leaf.redis.pool.min-idle:16}")
	private int minidle;
	@Value("${leaf.redis.pool.max-wait:2000}")
	private int maxwait;
	@Value("${leaf.redis.pool.max-active:21}")
	private int maxactive;
	@Value("${leaf.redis.type:1}")
	private int type;
	@Value("${leaf.redis.sentinel.master:}")
	private String sentinelMaster;
	@Value("${leaf.redis.sentinel.nodes:}")
	private String sentinelNodes;
	
	public String getHostname() {
		return hostname;
	}
	public void setHostname(String hostname) {
		this.hostname = hostname;
	}
	public int getPort() {
		return port;
	}
	public void setPort(int port) {
		this.port = port;
	}
	public String getPassword() {
		return password;
	}
	public void setPassword(String password) {
		this.password = password;
	}
	public int getTimeout() {
		return timeout;
	}
	public void setTimeout(int timeout) {
		this.timeout = timeout;
	}
	public int getMaxidle() {
		return maxidle;
	}
	public void setMaxidle(int maxidle) {
		this.maxidle = maxidle;
	}
	public int getMinidle() {
		return minidle;
	}
	public void setMinidle(int mindile) {
		this.minidle = mindile;
	}
	public int getMaxwait() {
		return maxwait;
	}
	public void setMaxwait(int maxwait) {
		this.maxwait = maxwait;
	}
	public int getMaxactive() {
		return maxactive;
	}
	public void setMaxactive(int maxactive) {
		this.maxactive = maxactive;
	}
	public int getDatabase() {
		return database;
	}
	public void setDatabase(int database) {
		this.database = database;
	}
	public int getType() {
		return type;
	}
	public void setType(int type) {
		this.type = type;
	}
	
	/**
	 * @return the sentinelMaster
	 */
	public String getSentinelMaster() {
		return sentinelMaster;
	}
	/**
	 * @param sentinelMaster the sentinelMaster to set
	 */
	public void setSentinelMaster(String sentinelMaster) {
		this.sentinelMaster = sentinelMaster;
	}
	/**
	 * @return the sentinelNodes
	 */
	public String getSentinelNodes() {
		return sentinelNodes;
	}
	/**
	 * @param sentinelNodes the sentinelNodes to set
	 */
	public void setSentinelNodes(String sentinelNodes) {
		this.sentinelNodes = sentinelNodes;
	}
	public void setConfigProperties(String name, String values) {
		 if (name.contains("database")) {
			 setDatabase(Integer.valueOf(values));
		 } 
		 if (name.contains("host-name")) {
			 setHostname(values);
		 } 
		 if (name.contains("port")) {
			 setPort(Integer.valueOf(values));
		 } 
		 if (name.contains("password")) {
			setPassword(values);
		 } 
		 if (name.contains("timeout")) {
			 setTimeout(Integer.valueOf(values));
		 } 
		 if (name.contains("max-idle")) {
			 setMaxidle(Integer.valueOf(values));
		 } 
		 if (name.contains("min-idle")) {
			 setMinidle(Integer.valueOf(values));
		 } 
		 if (name.contains("max-wait")) {
			 setMaxwait(Integer.valueOf(values));
		 } 
		 if (name.contains("max-active")) {
			 setMaxactive(Integer.valueOf(values));
		 }
		 if (name.contains("sentinel.master")) {
			 setSentinelMaster(values);
		 }
		 if (name.contains("sentinel.nodes")) {
			 setSentinelNodes(values);
		 }
	 }
	
	
}
