/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.component.uid.util;

import com.cache.CacheFactory;
import com.cache.redis.config.CacheConfig;
import com.cusc.component.uid.config.RedisConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RedisCenter {
    private static Logger logger = LoggerFactory.getLogger(RedisCenter.class);
    private static final String key = "uid-service";
    @Autowired
    private RedisConfiguration redisConfig;
    private static CacheFactory leafCacheFactory;
    private static CacheConfig config;

    public RedisCenter(RedisConfiguration redisConfiguration) {
        this.redisConfig = redisConfiguration;
    }

    @PostConstruct
    public void initconfig() {
        if (this.redisConfig.getType() == 1) {
            config = new CacheConfig();
            config.setKey(key);
            config.setHostName(this.redisConfig.getHostname());
            config.setPort(Integer.valueOf(this.redisConfig.getPort()));
            config.setDatabase(Integer.valueOf(this.redisConfig.getDatabase()));
            config.setPassword(this.redisConfig.getPassword());
            config.setType(Integer.valueOf(this.redisConfig.getType()));
            config.setTimeout(Integer.valueOf(this.redisConfig.getTimeout()));
            config.setMaxIdle(Integer.valueOf(this.redisConfig.getMaxidle()));
            config.setMinIdle(Integer.valueOf(this.redisConfig.getMinidle()));
            config.setMaxWaitMillis(Integer.valueOf(this.redisConfig.getMaxwait()));
            config.setMaxActive(Integer.valueOf(this.redisConfig.getMaxactive()));
        } else if (this.redisConfig.getType() == 2) {
            config = new CacheConfig();
            config.setKey(key);
            config.setPassword(this.redisConfig.getPassword());
            config.setType(Integer.valueOf(this.redisConfig.getType()));
            config.setSentinelMasterName(this.redisConfig.getSentinelMaster());
            config.setSentinelSet(RedisCenter.getSetNodes(this.redisConfig.getSentinelNodes()));
            config.setTimeout(Integer.valueOf(this.redisConfig.getTimeout()));
            config.setMaxIdle(Integer.valueOf(this.redisConfig.getMaxidle()));
            config.setMinIdle(Integer.valueOf(this.redisConfig.getMinidle()));
            config.setMaxWaitMillis(Integer.valueOf(this.redisConfig.getMaxwait()));
            config.setMaxActive(Integer.valueOf(this.redisConfig.getMaxactive()));
        } else {
            throw new RuntimeException("type\u662f\u4e0d\u652f\u6301\u7684\u96c6\u7fa4\u7c7b\u522b\uff01\u8bf7\u8054\u7cfb\u6280\u672f\u4e2d\u53f0\u589e\u52a0\u7248\u672c\u652f\u6301\uff01");
        }
        this.init();
    }

    private static Set<String> getSetNodes(String node) {
        if (StringUtils.isBlank((CharSequence)node)) {
            return Collections.emptySet();
        }
        return new HashSet<String>(RedisCenter.getStringSet(node));
    }

    private static List<String> getStringSet(String v) {
        if (StringUtils.isBlank((CharSequence)v)) {
            return Collections.emptyList();
        }
        return Arrays.asList(v.trim().split(","));
    }

    private void initStart() {
        if (null == leafCacheFactory) {
            this.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (null != config) {
            if (null != leafCacheFactory) {
                CacheFactory cacheFactory = leafCacheFactory;
                synchronized (cacheFactory) {
                    leafCacheFactory = new CacheFactory(config);
                }
            } else {
                leafCacheFactory = new CacheFactory(config);
            }
            logger.info("T3Cache : Configuration injection succeeded ... host is :{} ", (Object)config.getHostName());
        }
    }

    public boolean hset(String key, String field, String value) {
        try {
            this.initStart();
            leafCacheFactory.getInternalService().hset(key, field, value, -1);
            return true;
        }
        catch (Exception e) {
            logger.error("hset failed,key:{}, field:{}, value:{}, exception:{}", new Object[]{key, field, value, e});
            return false;
        }
    }

    public String hget(String key, String item) {
        try {
            this.initStart();
            return leafCacheFactory.getInternalService().hget(key, item);
        }
        catch (Exception e) {
            logger.error("hget failed,key:{}, item:{}, exception:{}", new Object[]{key, item, e});
            return null;
        }
    }

    public Long incr(String key) {
        try {
            this.initStart();
            return leafCacheFactory.getInternalService().incr(key, 1L, -1);
        }
        catch (Exception e) {
            logger.error("incr failed,key:{}, exception:{}", (Object)key, (Object)e);
            return 0L;
        }
    }

    public boolean lock(String lockKey, String requestId, Integer expireTime) {
        try {
            this.initStart();
            return leafCacheFactory.getInternalService().lock(lockKey, requestId, expireTime.intValue());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean unlock(String lockKey, String requestId) {
        try {
            this.initStart();
            return leafCacheFactory.getInternalService().unLock(lockKey, requestId);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public List<String> queryKey(String keys) {
        try {
            this.initStart();
            return new ArrayList<String>(leafCacheFactory.getInternalService().hkeys(keys));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean dislock(String key, String value, Integer expire, Integer waitTime, Integer reCount) {
        try {
            this.initStart();
            return leafCacheFactory.getInternalService().lockAndWait(key, value, expire.intValue(), waitTime.intValue(), reCount.intValue());
        }
        catch (Exception e) {
            return false;
        }
    }

    public void restart() {
        this.initconfig();
    }
}

