/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.component.uid.util;

import java.lang.management.ManagementFactory;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateFormatUtils;

public class DateUtils
extends org.apache.commons.lang3.time.DateUtils {
    private static String[] parsePatterns = new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyy/MM", "yyyy.MM.dd", "yyyy.MM.dd HH:mm:ss", "yyyy.MM.dd HH:mm", "yyyy.MM"};
    public static String YYYY = "yyyy";
    public static String YYYY_MM = "yyyy-MM";
    public static String YYYY_MM_DD = "yyyy-MM-dd";
    public static String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";

    public static final String datePath() {
        Date now = new Date();
        return DateFormatUtils.format((Date)now, (String)"yyyy/MM/dd");
    }

    public static final String dateTime() {
        Date now = new Date();
        return DateFormatUtils.format((Date)now, (String)"yyyyMMdd");
    }

    public static final String dateTime(Date date) {
        return DateUtils.parseDateToStr(YYYY_MM_DD, date);
    }

    public static final Date dateTime(String format, String ts) {
        try {
            return new SimpleDateFormat(format).parse(ts);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static final String dateTimeNow() {
        return DateUtils.dateTimeNow(YYYYMMDDHHMMSS);
    }

    public static final String dateTimeNow(String format) {
        return DateUtils.parseDateToStr(format, new Date());
    }

    public static List<String> getAllPassDaysByDesc(int days, String format) {
        ArrayList<String> daysList = new ArrayList<String>();
        if (days > 0) {
            for (int index = 0; index < days; ++index) {
                daysList.add(DateUtils.getPassDate(index, format));
            }
        }
        return daysList;
    }

    public static List<String> getAllPassDaysByAsc(int days, String format) {
        ArrayList<String> daysList = new ArrayList<String>();
        if (days > 0) {
            for (int index = days; index > 0; --index) {
                daysList.add(DateUtils.getPassDate(index - 1, format));
            }
        }
        return daysList;
    }

    public static String getDate() {
        return DateUtils.dateTimeNow(YYYY_MM_DD);
    }

    public static String getDatePoor(Date endDate, Date nowDate) {
        long nd = 86400000L;
        long nh = 3600000L;
        long nm = 60000L;
        long diff = endDate.getTime() - nowDate.getTime();
        long day = diff / nd;
        long hour = diff % nd / nh;
        long min = diff % nd % nh / nm;
        return day + "\u5929" + hour + "\u5c0f\u65f6" + min + "\u5206\u949f";
    }

    public static Date getNowDate() {
        return new Date();
    }

    public static String getPassDate(int days, String format) {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat sdf1 = new SimpleDateFormat(format);
        calendar.add(5, days * -1);
        String days_ago = sdf1.format(calendar.getTime());
        return days_ago;
    }

    public static Date getServerStartDate() {
        long time = ManagementFactory.getRuntimeMXBean().getStartTime();
        return new Date(time);
    }

    public static final String getTime() {
        return DateUtils.dateTimeNow(YYYY_MM_DD_HH_MM_SS);
    }

    public static Date parseDate(Object str) {
        if (str == null) {
            return null;
        }
        try {
            return DateUtils.parseDate((String)str.toString(), (String[])parsePatterns);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static final String parseDateToStr(String format, Date date) {
        return new SimpleDateFormat(format).format(date);
    }
}

