/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.component.uid.service.impl;

import com.cusc.component.uid.config.SegmentConfig;
import com.cusc.component.uid.core.Result;
import com.cusc.component.uid.dao.impl.IDAllocDaoImpl;
import com.cusc.component.uid.exception.InitException;
import com.cusc.component.uid.service.IDGen;
import com.cusc.component.uid.service.impl.SegmentIDGenImpl;
import com.cusc.component.uid.service.impl.ZeroIDGen;
import com.cusc.component.uid.util.RedisCenter;
import java.sql.SQLException;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="SegmentService")
public class SegmentService {
    private Logger logger = LoggerFactory.getLogger(SegmentService.class);
    IDGen idGen;
    @Autowired
    SegmentConfig segmentConfig;
    @Autowired
    RedisCenter redisService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PostConstruct
    public void init() throws SQLException, InitException {
        this.logger.info("\u5206\u6bb5\u6a21\u5f0f\u662f\u5426\u5f00\u542f:{}", (Object)this.segmentConfig.isEnable());
        if (this.segmentConfig.isEnable()) {
            IDAllocDaoImpl dao = new IDAllocDaoImpl(this.redisService);
            this.idGen = new SegmentIDGenImpl();
            ((SegmentIDGenImpl)this.idGen).setDao(dao);
            if (!this.idGen.init()) throw new InitException("Segment Service Init Fail");
            this.logger.info("Segment Service Init Successfully");
            return;
        } else {
            this.idGen = new ZeroIDGen();
            this.logger.info("Zero ID Gen Service Init Successfully");
        }
    }

    public Result getId(String key) {
        return this.idGen.get(key);
    }

    public Result getContinuId(String key) {
        return this.idGen.getContinu(key);
    }

    public Result getDayContinueCode(String domainKey, String prefixCode, String dayFormat, String codeFormat) {
        return this.idGen.getDayContinueCode(domainKey, prefixCode, dayFormat, codeFormat);
    }

    public SegmentIDGenImpl getIdGen() {
        if (this.idGen instanceof SegmentIDGenImpl) {
            return (SegmentIDGenImpl)this.idGen;
        }
        return null;
    }
}

