/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.component.uid.service.impl;

import com.cusc.component.uid.core.LeafAlloc;
import com.cusc.component.uid.core.Result;
import com.cusc.component.uid.core.ResultCode;
import com.cusc.component.uid.core.ResultGenerator;
import com.cusc.component.uid.core.Segment;
import com.cusc.component.uid.core.SegmentBuffer;
import com.cusc.component.uid.dao.IDAllocDao;
import com.cusc.component.uid.service.IDGen;
import com.cusc.component.uid.util.DateUtils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.perf4j.slf4j.Slf4JStopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentIDGenImpl
implements IDGen {
    private static final Logger logger = LoggerFactory.getLogger(SegmentIDGenImpl.class);
    private static final int MAX_STEP = 1000000;
    private static final long SEGMENT_DURATION = 900000L;
    private ExecutorService service = new ThreadPoolExecutor(10, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new UpdateThreadFactory());
    private volatile boolean initOK = false;
    private Map<String, SegmentBuffer> cache = new ConcurrentHashMap<String, SegmentBuffer>();
    private IDAllocDao dao;
    private String aim_key;

    @Override
    public boolean init() {
        logger.info("Init ...");
        this.updateCacheFromDb();
        this.initOK = true;
        this.updateCacheFromDbAtEveryMinute();
        return this.initOK;
    }

    private void updateCacheFromDbAtEveryMinute() {
        ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("check-idCache-thread");
                t.setDaemon(true);
                return t;
            }
        });
        service.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                SegmentIDGenImpl.this.updateCacheFromDb();
            }
        }, 60L, 60L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCacheFromDb() {
        logger.info("update cache from db");
        Slf4JStopWatch sw = new Slf4JStopWatch();
        try {
            List<String> dbTags = this.dao.getAllKeys();
            if (dbTags == null || dbTags.isEmpty()) {
                return;
            }
            ArrayList<String> cacheTags = new ArrayList<String>(this.cache.keySet());
            ArrayList<String> insertTags = new ArrayList<String>(dbTags);
            ArrayList<String> removeTags = new ArrayList<String>(cacheTags);
            insertTags.removeAll(cacheTags);
            for (String tag : insertTags) {
                SegmentBuffer buffer = new SegmentBuffer();
                buffer.setKey(tag);
                Segment segment = buffer.getCurrent();
                segment.setValue(new AtomicLong(0L));
                segment.setMax(0L);
                segment.setStep(0);
                this.cache.put(tag, buffer);
                logger.info("Add tag {} from db to IdCache, SegmentBuffer {}", (Object)tag, (Object)buffer);
            }
            removeTags.removeAll(dbTags);
            for (String tag : removeTags) {
                this.cache.remove(tag);
                logger.info("Remove tag {} from IdCache", (Object)tag);
            }
        }
        catch (Exception e) {
            logger.warn("update cache from db exception", (Throwable)e);
        }
        finally {
            sw.stop("updateCacheFromDb");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result get(String key) {
        if (!this.initOK) {
            return ResultGenerator.genFailResult(ResultCode.ID_IDCACHE_INIT_FALSE, "IDCache\u672a\u521d\u59cb\u5316\u6210\u529f!");
        }
        if (this.cache.containsKey(key)) {
            SegmentBuffer buffer = this.cache.get(key);
            if (!buffer.isInitOk()) {
                SegmentBuffer segmentBuffer = buffer;
                synchronized (segmentBuffer) {
                    if (!buffer.isInitOk()) {
                        try {
                            this.updateSegmentFromDb(key, buffer.getCurrent());
                            logger.info("Init buffer. Update leafkey {} {} from db", (Object)key, (Object)buffer.getCurrent());
                            buffer.setInitOk(true);
                        }
                        catch (Exception e) {
                            logger.warn("Init buffer {} exception", (Object)buffer.getCurrent(), (Object)e);
                        }
                    }
                }
            }
            return this.getIdFromSegmentBuffer(this.cache.get(key));
        }
        return ResultGenerator.genFailResult(ResultCode.ID_KEY_NOT_EXISTS, "key\u4e0d\u5b58\u5728\uff0c\u8054\u7cfb\u4e2d\u95f4\u4ef6\u7533\u8bf7!");
    }

    public void updateSegmentFromDb(String key, Segment segment) {
        LeafAlloc leafAlloc;
        Slf4JStopWatch sw = new Slf4JStopWatch();
        SegmentBuffer buffer = segment.getBuffer();
        if (!buffer.isInitOk()) {
            leafAlloc = this.dao.updateMaxIdAndGet(key);
            buffer.setStep(leafAlloc.getStep());
            buffer.setMinStep(leafAlloc.getStep());
        } else if (buffer.getUpdateTimestamp() == 0L) {
            leafAlloc = this.dao.updateMaxIdAndGet(key);
            buffer.setUpdateTimestamp(System.currentTimeMillis());
            buffer.setMinStep(leafAlloc.getStep());
        } else {
            long duration = System.currentTimeMillis() - buffer.getUpdateTimestamp();
            int nextStep = buffer.getStep();
            if (duration < 900000L) {
                if (nextStep * 2 <= 1000000) {
                    nextStep *= 2;
                }
            } else if (duration >= 1800000L) {
                nextStep = nextStep / 2 >= buffer.getMinStep() ? nextStep / 2 : nextStep;
            }
            logger.info("leafKey[{}], step[{}], duration[{}mins], nextStep[{}]", new Object[]{key, buffer.getStep(), String.format("%.2f", (double)duration / 60000.0), nextStep});
            LeafAlloc temp = new LeafAlloc();
            temp.setKey(key);
            temp.setStep(nextStep);
            leafAlloc = this.dao.updateMaxIdByCustomStep(temp);
            buffer.setUpdateTimestamp(System.currentTimeMillis());
            buffer.setStep(nextStep);
            buffer.setMinStep(leafAlloc.getStep());
        }
        long value = leafAlloc.getMaxId() - (long)buffer.getStep();
        segment.getValue().set(value);
        segment.setMax(leafAlloc.getMaxId());
        segment.setStep(buffer.getStep());
        sw.stop("updateSegmentFromDb", key + " " + segment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result getIdFromSegmentBuffer(final SegmentBuffer buffer) {
        while (true) {
            long value;
            Segment segment;
            try {
                buffer.rLock().lock();
                segment = buffer.getCurrent();
                if (!buffer.isNextReady() && (double)segment.getIdle() < 0.9 * (double)segment.getStep() && buffer.getThreadRunning().compareAndSet(false, true)) {
                    this.service.execute(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Segment next = buffer.getSegments()[buffer.nextPos()];
                            boolean updateOk = false;
                            try {
                                SegmentIDGenImpl.this.updateSegmentFromDb(buffer.getKey(), next);
                                updateOk = true;
                                logger.info("update segment {} from db {}", (Object)buffer.getKey(), (Object)next);
                            }
                            catch (Exception e) {
                                logger.warn(buffer.getKey() + " updateSegmentFromDb exception", (Throwable)e);
                            }
                            finally {
                                if (updateOk) {
                                    buffer.wLock().lock();
                                    buffer.setNextReady(true);
                                    buffer.getThreadRunning().set(false);
                                    buffer.wLock().unlock();
                                } else {
                                    buffer.getThreadRunning().set(false);
                                }
                            }
                        }
                    });
                }
                if ((value = segment.getValue().getAndIncrement()) < segment.getMax()) {
                    Result result = ResultGenerator.genSuccessResult(value);
                    return result;
                }
            }
            finally {
                buffer.rLock().unlock();
            }
            this.waitAndSleep(buffer);
            try {
                buffer.wLock().lock();
                segment = buffer.getCurrent();
                value = segment.getValue().getAndIncrement();
                if (value < segment.getMax()) {
                    Result result = ResultGenerator.genSuccessResult(value);
                    return result;
                }
                if (buffer.isNextReady()) {
                    buffer.switchPos();
                    buffer.setNextReady(false);
                    continue;
                }
                logger.error("Both two segments in {} are not ready!", (Object)buffer);
                Result result = ResultGenerator.genFailResult(ResultCode.ID_TWO_SEGMENTS_ARE_NULL, "SegmentBuffer\u4e2d\u7684\u4e24\u4e2aSegment\u5747\u672a\u4eceDB\u4e2d\u88c5\u8f7d");
                return result;
            }
            finally {
                buffer.wLock().unlock();
                continue;
            }
            break;
        }
    }

    private void waitAndSleep(SegmentBuffer buffer) {
        int roll = 0;
        while (buffer.getThreadRunning().get()) {
            if (++roll <= 10000) continue;
            try {
                Thread.currentThread();
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                logger.warn("Thread {} Interrupted", (Object)Thread.currentThread().getName());
                Thread.currentThread().interrupt();
            }
            break;
        }
    }

    public Map<String, SegmentBuffer> getCache() {
        return this.cache;
    }

    public IDAllocDao getDao() {
        return this.dao;
    }

    public void setDao(IDAllocDao dao) {
        this.dao = dao;
    }

    @Override
    public Result getContinu(String key) {
        if (!this.initOK) {
            return ResultGenerator.genFailResult(ResultCode.ID_IDCACHE_INIT_FALSE, "IDCache\u672a\u521d\u59cb\u5316\u6210\u529f!");
        }
        if (this.cache.containsKey(key)) {
            this.setAimKey(key);
            Long id = this.dao.incrKey(this.aim_key);
            if (id >= 1L) {
                return ResultGenerator.genSuccessResult(id);
            }
            return ResultGenerator.genFailResult(ResultCode.FAIL, "\u83b7\u53d6\u5931\u8d25\uff0c\u503c\u5c0f\u4e8e1!");
        }
        return ResultGenerator.genFailResult(ResultCode.ID_KEY_NOT_EXISTS, "key\u4e0d\u5b58\u5728\uff0c\u8054\u7cfb\u4e2d\u95f4\u4ef6\u7533\u8bf7!");
    }

    private void setAimKey(String key) {
        if (null == this.aim_key || !this.aim_key.split(":")[2].equals(key)) {
            StringBuffer keys = new StringBuffer("CP:UID:").append(key);
            this.aim_key = keys.toString();
        }
    }

    @Override
    public Result getDayContinueCode(String domainKey, String prefixCode, String dayFormat, String codeFormat) {
        if (!this.initOK) {
            return ResultGenerator.genFailResult(ResultCode.ID_IDCACHE_INIT_FALSE, "IDCache\u672a\u521d\u59cb\u5316\u6210\u529f!");
        }
        if (this.cache.containsKey(domainKey)) {
            String dateTime = DateUtils.dateTime();
            if (StringUtils.isNotBlank((CharSequence)dayFormat)) {
                dateTime = DateUtils.dateTimeNow(dayFormat);
            }
            String key = domainKey + ":" + dateTime;
            this.setAimKey(key);
            Long id = this.dao.incrKey(this.aim_key);
            if (id >= 1L) {
                String codeInitial = "000000";
                if (StringUtils.isNotBlank((CharSequence)codeFormat)) {
                    codeInitial = codeFormat;
                }
                DecimalFormat df = new DecimalFormat(codeInitial);
                String stringValue = df.format(id);
                StringBuffer sb = new StringBuffer();
                if (StringUtils.isNotBlank((CharSequence)prefixCode)) {
                    sb.append(prefixCode);
                }
                sb.append(dateTime);
                sb.append(stringValue);
                return ResultGenerator.genSuccessResult(sb.toString());
            }
            return ResultGenerator.genFailResult(ResultCode.FAIL, "\u83b7\u53d6\u5931\u8d25\uff0c\u503c\u5c0f\u4e8e1!");
        }
        return ResultGenerator.genFailResult(ResultCode.ID_KEY_NOT_EXISTS, "key\u4e0d\u5b58\u5728\uff0c\u8054\u7cfb\u4e2d\u95f4\u4ef6\u7533\u8bf7!");
    }

    public static class UpdateThreadFactory
    implements ThreadFactory {
        private static int threadInitNumber = 0;

        private static synchronized int nextThreadNum() {
            return threadInitNumber++;
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "Thread-Segment-Update-" + UpdateThreadFactory.nextThreadNum());
        }
    }
}

