/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.component.uid.dao.impl;

import com.alibaba.fastjson.JSONObject;
import com.cusc.component.uid.core.LeafAlloc;
import com.cusc.component.uid.dao.IDAllocDao;
import com.cusc.component.uid.util.RedisCenter;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IDAllocDaoImpl
implements IDAllocDao {
    private static final Logger logger = LoggerFactory.getLogger(IDAllocDaoImpl.class);
    private static Integer LOCK_MILLS = 5000;
    private static Integer RETRY_TIMES = 50;
    private static Integer SLEEP_THREAD = 100;
    RedisCenter redisService;

    public IDAllocDaoImpl(RedisCenter redisService) {
        this.redisService = redisService;
    }

    @Override
    public LeafAlloc updateMaxIdAndGet(String tag) {
        try {
            String res = this.redisService.hget("CP:UID:ENTITY", tag);
            LeafAlloc leafs = (LeafAlloc)JSONObject.parseObject((String)res, LeafAlloc.class);
            leafs.setMaxId(leafs.getMaxId() + (long)leafs.getStep());
            String uuid = UUID.randomUUID().toString().replace("-", "");
            if (this.redisService.dislock("CP:UID:LOCK:" + leafs.getKey(), uuid, LOCK_MILLS, SLEEP_THREAD, RETRY_TIMES)) {
                this.redisService.hset("CP:UID:ENTITY", leafs.getKey(), JSONObject.toJSONString((Object)leafs));
                this.redisService.unlock("CP:UID:LOCK:" + leafs.getKey(), uuid);
            }
            return leafs;
        }
        catch (Exception e) {
            logger.error("updateMaxIdAndGet failed,exception:{}", (Object)e.toString());
            return null;
        }
    }

    @Override
    public LeafAlloc updateMaxIdByCustomStep(LeafAlloc leafAlloc) {
        try {
            String res = this.redisService.hget("CP:UID:ENTITY", leafAlloc.getKey());
            LeafAlloc leafs = (LeafAlloc)JSONObject.parseObject((String)res, LeafAlloc.class);
            leafs.setMaxId(leafs.getMaxId() + (long)leafAlloc.getStep());
            String uuid = UUID.randomUUID().toString().replace("-", "");
            if (this.redisService.dislock("CP:UID:LOCK:" + leafs.getKey(), uuid, LOCK_MILLS, SLEEP_THREAD, RETRY_TIMES)) {
                this.redisService.hset("CP:UID:ENTITY", leafAlloc.getKey(), JSONObject.toJSONString((Object)leafs));
                this.redisService.unlock("CP:UID:LOCK:" + leafs.getKey(), uuid);
            }
            return leafs;
        }
        catch (Exception e) {
            logger.error("updateMaxIdAndGet failed,exception:{}", (Object)e.toString());
            return null;
        }
    }

    @Override
    public List<String> getAllKeys() {
        return this.redisService.queryKey("CP:UID:ENTITY");
    }

    @Override
    public Long incrKey(String key) {
        try {
            return this.redisService.incr(key);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6ID\u5931\u8d25\uff0ckey: {},exception:", (Object)key, (Object)e);
            return null;
        }
    }
}

