/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.component.uid.core;

import com.cusc.component.uid.core.Segment;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SegmentBuffer {
    private String key;
    private Segment[] segments = new Segment[]{new Segment(this), new Segment(this)};
    private volatile int currentPos = 0;
    private volatile boolean nextReady = false;
    private volatile boolean initOk = false;
    private final AtomicBoolean threadRunning = new AtomicBoolean(false);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private volatile int step;
    private volatile int minStep;
    private volatile long updateTimestamp;

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Segment[] getSegments() {
        return this.segments;
    }

    public Segment getCurrent() {
        return this.segments[this.currentPos];
    }

    public int getCurrentPos() {
        return this.currentPos;
    }

    public int nextPos() {
        return (this.currentPos + 1) % 2;
    }

    public void switchPos() {
        this.currentPos = this.nextPos();
    }

    public boolean isInitOk() {
        return this.initOk;
    }

    public void setInitOk(boolean initOk) {
        this.initOk = initOk;
    }

    public boolean isNextReady() {
        return this.nextReady;
    }

    public void setNextReady(boolean nextReady) {
        this.nextReady = nextReady;
    }

    public AtomicBoolean getThreadRunning() {
        return this.threadRunning;
    }

    public Lock rLock() {
        return this.lock.readLock();
    }

    public Lock wLock() {
        return this.lock.writeLock();
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int step) {
        this.step = step;
    }

    public int getMinStep() {
        return this.minStep;
    }

    public void setMinStep(int minStep) {
        this.minStep = minStep;
    }

    public long getUpdateTimestamp() {
        return this.updateTimestamp;
    }

    public void setUpdateTimestamp(long updateTimestamp) {
        this.updateTimestamp = updateTimestamp;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SegmentBuffer{");
        sb.append("key='").append(this.key).append('\'');
        sb.append(", segments=").append(Arrays.toString(this.segments));
        sb.append(", currentPos=").append(this.currentPos);
        sb.append(", nextReady=").append(this.nextReady);
        sb.append(", initOk=").append(this.initOk);
        sb.append(", threadRunning=").append(this.threadRunning);
        sb.append(", step=").append(this.step);
        sb.append(", minStep=").append(this.minStep);
        sb.append(", updateTimestamp=").append(this.updateTimestamp);
        sb.append('}');
        return sb.toString();
    }
}

