/*
 * Decompiled with CFR 0.152.
 */
package com.job.util;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpUtil {
    private static final Logger logger = LoggerFactory.getLogger(IpUtil.class);
    private static final String ANYHOST = "0.0.0.0";
    private static final String LOCALHOST = "127.0.0.1";
    private static final Pattern IP_PATTERN = Pattern.compile("\\d{1,3}(\\.\\d{1,3}){3,5}$");
    private static volatile InetAddress LOCAL_ADDRESS = null;

    private static boolean isValidAddress(InetAddress address) {
        if (address == null || address.isLoopbackAddress()) {
            return false;
        }
        String name = address.getHostAddress();
        return name != null && !ANYHOST.equals(name) && !LOCALHOST.equals(name) && IP_PATTERN.matcher(name).matches();
    }

    private static boolean isValidV6Address(Inet6Address address) {
        boolean preferIpv6 = Boolean.getBoolean("java.net.preferIPv6Addresses");
        if (!preferIpv6) {
            return false;
        }
        try {
            return address.isReachable(100);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static InetAddress normalizeV6Address(Inet6Address address) {
        String addr = address.getHostAddress();
        int i = addr.lastIndexOf(37);
        if (i > 0) {
            try {
                return InetAddress.getByName(addr.substring(0, i) + '%' + address.getScopeId());
            }
            catch (UnknownHostException e) {
                logger.debug("Unknown IPV6 address: ", (Throwable)e);
            }
        }
        return address;
    }

    private static InetAddress getLocalAddress0() {
        InetAddress localAddress = null;
        try {
            localAddress = InetAddress.getLocalHost();
            if (localAddress instanceof Inet6Address) {
                Inet6Address address = (Inet6Address)localAddress;
                if (IpUtil.isValidV6Address(address)) {
                    return IpUtil.normalizeV6Address(address);
                }
            } else if (IpUtil.isValidAddress(localAddress)) {
                return localAddress;
            }
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            if (null == interfaces) {
                return localAddress;
            }
            while (interfaces.hasMoreElements()) {
                try {
                    NetworkInterface network = interfaces.nextElement();
                    Enumeration<InetAddress> addresses = network.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        try {
                            InetAddress address = addresses.nextElement();
                            if (address instanceof Inet6Address) {
                                Inet6Address v6Address = (Inet6Address)address;
                                if (!IpUtil.isValidV6Address(v6Address)) continue;
                                return IpUtil.normalizeV6Address(v6Address);
                            }
                            if (!IpUtil.isValidAddress(address)) continue;
                            return address;
                        }
                        catch (Throwable e) {
                            logger.error(e.getMessage(), e);
                        }
                    }
                }
                catch (Throwable e) {
                    logger.error(e.getMessage(), e);
                }
            }
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
        return localAddress;
    }

    public static InetAddress getLocalAddress() {
        InetAddress localAddress;
        if (LOCAL_ADDRESS != null) {
            return LOCAL_ADDRESS;
        }
        LOCAL_ADDRESS = localAddress = IpUtil.getLocalAddress0();
        return localAddress;
    }

    public static String getIp() {
        return IpUtil.getLocalAddress().getHostAddress();
    }

    public static String getIpPort(int port) {
        String ip = IpUtil.getIp();
        return IpUtil.getIpPort(ip, port);
    }

    public static String getIpPort(String ip, int port) {
        if (ip == null) {
            return null;
        }
        return ip.concat(":").concat(String.valueOf(port));
    }

    public static Object[] parseIpPort(String address) {
        String[] array = address.split(":");
        String host = array[0];
        int port = Integer.parseInt(array[1]);
        return new Object[]{host, port};
    }
}

