/*
 * Decompiled with CFR 0.152.
 */
package com.job.service;

import com.alibaba.fastjson.JSONObject;
import com.job.cache.JobMethod;
import com.job.cache.MethodCache;
import com.job.http.PostJsonUtil;
import com.job.http.Response;
import com.job.model.HeartModel;
import com.job.model.JobModel;
import com.job.util.ArrayUtil;
import com.job.util.IpUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"job.server-addresses"})
public class JobService
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(JobService.class);
    private static final String MAPPING_REGISTER = "/register";
    private static final String MAPPING_REMOVE = "/remove";
    private static final String MAPPING_HEART = "/heart";
    @Value(value="${job.server-addresses}")
    private String serverAddresses;
    @Value(value="${app.id}")
    private String appName;
    @Value(value="${server.port}")
    private int appServerPort;
    @Value(value="${server.servlet.context-path:}")
    private String context_path;
    private volatile boolean isStop = false;

    public Response register(String callback, String jobName, String cron, int shardingTotalCount, String parameter, String content) {
        JobModel jobModel = new JobModel();
        jobModel.setCallback(callback);
        jobModel.setAppName(this.appName);
        jobModel.setAddress(this.getIpAndPort());
        jobModel.setJobName(jobName);
        jobModel.setCron(cron);
        jobModel.setShardingTotalCount(shardingTotalCount);
        jobModel.setParameter(parameter);
        jobModel.setContent(content);
        String[] serverAddrs = this.serverAddresses.split(",");
        for (String serverAddr : serverAddrs = ArrayUtil.randomSort(serverAddrs)) {
            try {
                Response response = PostJsonUtil.doPostJson(serverAddr + MAPPING_REGISTER, JSONObject.toJSONString((Object)jobModel));
                return response;
            }
            catch (Exception e) {
                logger.error("\u6ce8\u518c\u4f5c\u4e1a\u5931\u8d25,\u539f\u56e0;", (Throwable)e);
            }
        }
        return Response.createError("\u6ce8\u518c\u4f5c\u4e1a\u5931\u8d25");
    }

    public Response register(String callback, String jobName, String cron, Map<String, String> requestParam, int shardingTotalCount, String parameter, String content) {
        JobModel jobModel = new JobModel();
        jobModel.setCallback(callback);
        jobModel.setAppName(this.appName);
        jobModel.setAddress(this.getIpAndPort());
        jobModel.setJobName(jobName);
        jobModel.setCron(cron);
        jobModel.setShardingTotalCount(shardingTotalCount);
        jobModel.setParameter(parameter);
        jobModel.setContent(content);
        String[] serverAddrs = this.serverAddresses.split(",");
        for (String serverAddr : serverAddrs = ArrayUtil.randomSort(serverAddrs)) {
            try {
                Response response = null == requestParam || 0 == requestParam.size() ? PostJsonUtil.doPostJson(serverAddr + MAPPING_REGISTER, JSONObject.toJSONString((Object)jobModel)) : PostJsonUtil.doPostJsonWithHead(serverAddr + MAPPING_REGISTER, JSONObject.toJSONString((Object)jobModel), requestParam);
                return response;
            }
            catch (Exception e) {
                logger.error("\u6ce8\u518c\u4f5c\u4e1a\u5931\u8d25,\u539f\u56e0;", (Throwable)e);
            }
        }
        return Response.createError("\u6ce8\u518c\u4f5c\u4e1a\u5931\u8d25");
    }

    @Deprecated
    public Response remove(Long jobId) {
        String[] serverAddrs = this.serverAddresses.split(",");
        for (String serverAddr : serverAddrs = ArrayUtil.randomSort(serverAddrs)) {
            try {
                Response response = PostJsonUtil.doPostJson(serverAddr + MAPPING_REMOVE + "?jobId=" + jobId, "");
                return response;
            }
            catch (Exception e) {
                logger.error("\u5220\u9664\u4f5c\u4e1a\u5931\u8d25,\u539f\u56e0;", (Throwable)e);
            }
        }
        return Response.createError("\u5220\u9664\u4f5c\u4e1a\u5931\u8d25");
    }

    private boolean heart() {
        String[] serverAddrs = this.serverAddresses.split(",");
        Map<String, JobMethod> methodCache = MethodCache.getAll();
        ArrayList<String> callbacks = new ArrayList<String>();
        for (Map.Entry<String, JobMethod> entry : methodCache.entrySet()) {
            callbacks.add(entry.getKey());
        }
        HeartModel heartModel = new HeartModel();
        heartModel.setCallbacks(callbacks);
        heartModel.setAppName(this.appName);
        heartModel.setAddress(StringUtils.isBlank((CharSequence)this.context_path) ? this.getIpAndPort() : (this.context_path.startsWith("/") ? this.getIpAndPort() + this.context_path : this.getIpAndPort() + "/" + this.context_path));
        for (String serverAddr : serverAddrs = ArrayUtil.randomSort(serverAddrs)) {
            try {
                int code = PostJsonUtil.doPostJsonForGadMap(serverAddr + MAPPING_HEART, JSONObject.toJSONString((Object)heartModel));
                if (code == 200) {
                    return true;
                }
                logger.error("\u66f4\u65b0\u5fc3\u8df3\u4fe1\u606f\u5931\u8d25\uff0c{} {}, code\uff1a{}", new Object[]{serverAddr, heartModel, code});
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001\u5fc3\u8df3\u4fe1\u606f\u5931\u8d25\uff0c{} {}, \u539f\u56e0\uff1a", new Object[]{serverAddr, heartModel, e});
            }
        }
        return false;
    }

    private String getIpAndPort() {
        return IpUtil.getIpPort(this.appServerPort);
    }

    public void afterPropertiesSet() throws Exception {
        this.startHeartbeat();
    }

    private void startHeartbeat() {
        Thread heartBeatTheard = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!JobService.this.isStop) {
                    try {
                        JobService.this.heart();
                        TimeUnit.MILLISECONDS.sleep(30000L);
                    }
                    catch (Exception e) {
                        logger.error("\u4f5c\u4e1a\u5b9a\u65f6\u53d1\u9001\u670d\u52a1\u5668\u5fc3\u8df3\u5931\u8d25\uff0c\u539f\u56e0:", (Throwable)e);
                    }
                }
            }
        });
        heartBeatTheard.setDaemon(true);
        heartBeatTheard.setName("job, admin heartBeatThread");
        heartBeatTheard.start();
    }
}

