/*
 * Decompiled with CFR 0.152.
 */
package com.job.processor;

import com.alibaba.fastjson.JSONObject;
import com.job.annotation.Job;
import com.job.cache.JobMethod;
import com.job.cache.MethodCache;
import com.job.http.Response;
import com.job.service.JobService;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;

@Component
@ConditionalOnProperty(value={"job.server-addresses"})
public class JobListener {
    private static final Logger logger = LoggerFactory.getLogger(JobListener.class);
    @Value(value="${job.base-package:com.job}")
    private String basePackage;
    @Value(value="${job.maxRetryTimes:3}")
    private int maxRetryTimes;
    private int retryTimes = 0;
    @Autowired
    private JobService jobService;
    private static boolean registryFlag = true;
    @Autowired
    private Environment environment;

    @PostConstruct
    public void autoRegistry() {
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        String sourcePattern = "/**/*.class";
        try {
            String[] basePackages;
            if (StringUtils.isEmpty((CharSequence)this.basePackage)) {
                logger.error("\u4f60\u6ca1\u6709\u914d\u7f6ebase-package\uff0c\u8bf7\u5148\u914d\u7f6e\uff01");
                return;
            }
            ArrayList<Resource> resourcesList = new ArrayList<Resource>();
            for (String pack : basePackages = this.basePackage.split(",")) {
                String pattern = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)pack) + sourcePattern;
                Resource[] resources = resourcePatternResolver.getResources(pattern);
                if (resources == null || resources.length == 0) continue;
                for (Resource res : resources) {
                    resourcesList.add(res);
                }
            }
            CachingMetadataReaderFactory readerFactory = new CachingMetadataReaderFactory((ResourceLoader)resourcePatternResolver);
            for (Resource resource : resourcesList) {
                Method[] methods;
                MetadataReader reader = readerFactory.getMetadataReader(resource);
                String className = reader.getClassMetadata().getClassName();
                Class<?> clazz = Class.forName(className);
                for (Method method : methods = clazz.getDeclaredMethods()) {
                    Job jobAnnotation = method.getAnnotation(Job.class);
                    if (null == jobAnnotation) continue;
                    String jobName = jobAnnotation.jobName();
                    if (jobAnnotation.isAutoRegister() && StringUtils.isEmpty((CharSequence)jobName)) {
                        logger.error("\u4f5c\u4e1a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
                        continue;
                    }
                    JobMethod jobMethod = new JobMethod();
                    jobMethod.setClazz(clazz);
                    jobMethod.setMethod(method);
                    String cacheKey = StringUtils.isEmpty((CharSequence)jobAnnotation.callback()) ? jobAnnotation.jobName() : jobAnnotation.callback();
                    MethodCache.put(cacheKey, jobMethod);
                    if (!jobAnnotation.isAutoRegister()) continue;
                    HashMap<String, Object> jobInfo = new HashMap<String, Object>();
                    jobInfo.put("jobName", jobAnnotation.jobName());
                    jobInfo.put("callback", cacheKey);
                    String cron = jobAnnotation.cron();
                    if (StringUtils.isNotEmpty((CharSequence)cron) && cron.startsWith("$")) {
                        cron = this.environment.getProperty(cron.substring(cron.indexOf("{") + 1, cron.indexOf("}")));
                    }
                    jobInfo.put("cron", cron);
                    jobInfo.put("shardingTotalCount", jobAnnotation.shardingTotalCount());
                    jobInfo.put("parameter", jobAnnotation.parameter());
                    jobInfo.put("content", jobAnnotation.content());
                    Response response = this.jobService.register(cacheKey, jobAnnotation.jobName(), cron, jobAnnotation.shardingTotalCount(), jobAnnotation.parameter(), jobAnnotation.content());
                    logger.info("\u4f5c\u4e1a\u65b9\u6cd5\u6240\u5728\u7c7b\uff1a{}\uff0c\u56de\u8c03\u65b9\u6cd5\u540d\uff1a{}\uff0c\u6ce8\u518c\u4f5c\u4e1a\u4fe1\u606f\uff1a{}\uff0c\u6ce8\u518c\u7ed3\u679c:{}", new Object[]{jobMethod.getClazz().getName(), jobMethod.getMethod().getName(), JSONObject.toJSONString(jobInfo), JSONObject.toJSONString((Object)response)});
                    if (response.isSuccess()) continue;
                    registryFlag = false;
                }
            }
            if (!registryFlag && this.retryTimes++ < this.maxRetryTimes) {
                this.retryRegistry();
            }
        }
        catch (IOException | ClassNotFoundException e) {
            logger.error("\u6ce8\u518c\u4f5c\u4e1a\u56de\u8c03\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a", (Throwable)e);
        }
    }

    private void retryRegistry() {
        registryFlag = true;
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TimeUnit.SECONDS.sleep(60L);
                }
                catch (Exception e) {
                    logger.error("\u81ea\u52a8\u6ce8\u518c\u4f11\u7720\u65f6\u95f4\u5931\u8d25\uff0c\u539f\u56e0\uff1a", (Throwable)e);
                }
                logger.info("\u91cd\u8bd5\u81ea\u52a8\u6ce8\u518c\u4f5c\u4e1a\u4fe1\u606f\u81f3\u4f5c\u4e1a\u5e73\u53f0!");
                JobListener.this.autoRegistry();
            }
        }).start();
    }
}

