/*
 * Decompiled with CFR 0.152.
 */
package com.job.http;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.job.http.Response;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.ConnectionPool;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostJsonUtil {
    private static Logger logger = LoggerFactory.getLogger(PostJsonUtil.class);

    private PostJsonUtil() {
    }

    private static OkHttpClient getHttpClient() {
        return HttpClientInstance.HTTP_CLIENT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Response doPostJson(String url, String jsonParams) throws IOException {
        RequestBody requestBody = FormBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonParams);
        Request request = new Request.Builder().url(url).addHeader("Content-Type", "application/json").addHeader("Cache-Control", "no-cache").addHeader("GATEWAY", "JOB").post(requestBody).build();
        Call call = PostJsonUtil.getHttpClient().newCall(request);
        okhttp3.Response response = null;
        Response rsp = null;
        try {
            String body;
            JSONObject jsonObject;
            response = call.execute();
            rsp = response.isSuccessful() ? ((jsonObject = JSON.parseObject((String)(body = response.body().string()))).get((Object)"code").equals(200) ? Response.createSuccess("\u8c03\u7528\u6210\u529f!") : Response.createError("\u8c03\u7528\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + jsonObject.get((Object)"msg"))) : Response.createError("\u8c03\u7528\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + response.message());
        }
        finally {
            if (null != response) {
                response.close();
            }
        }
        return rsp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Response doPostJsonWithHead(String url, String jsonParams, Map<String, String> requestParam) throws IOException {
        RequestBody requestBody = FormBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonParams);
        Request.Builder builder = new Request.Builder().url(url).addHeader("Content-Type", "application/json").addHeader("Cache-Control", "no-cache").addHeader("GATEWAY", "JOB");
        requestParam.forEach((key, value) -> builder.addHeader("job-" + key, value));
        Request request = builder.post(requestBody).build();
        Call call = PostJsonUtil.getHttpClient().newCall(request);
        okhttp3.Response response = null;
        Response rsp = null;
        try {
            String body;
            JSONObject jsonObject;
            response = call.execute();
            rsp = response.isSuccessful() ? ((jsonObject = JSON.parseObject((String)(body = response.body().string()))).get((Object)"code").equals(200) ? Response.createSuccess("\u8c03\u7528\u6210\u529f!") : Response.createError("\u8c03\u7528\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + jsonObject.get((Object)"msg"))) : Response.createError("\u8c03\u7528\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + response.message());
        }
        finally {
            if (null != response) {
                response.close();
            }
        }
        return rsp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int doPostJsonForGadMap(String url, String jsonParams) throws Exception {
        RequestBody requestBody = FormBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonParams);
        Request request = new Request.Builder().url(url).addHeader("Content-Type", "application/json").addHeader("Cache-Control", "no-cache").addHeader("GATEWAY", "JOB").post(requestBody).build();
        Call call = PostJsonUtil.getHttpClient().newCall(request);
        okhttp3.Response response = null;
        int code = 0;
        try {
            response = call.execute();
            if (null != response) {
                code = response.code();
            }
        }
        finally {
            if (null != response) {
                response.close();
            }
        }
        return code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int doGet(String url) throws Exception {
        Request request = new Request.Builder().url(url).build();
        okhttp3.Response response = null;
        int code = 0;
        try {
            response = PostJsonUtil.getHttpClient().newCall(request).execute();
            if (null != response) {
                code = response.code();
            }
        }
        finally {
            if (null != response) {
                response.close();
            }
        }
        return code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doPutRequest(String url) throws IOException {
        FormBody body = new FormBody.Builder().build();
        Request request = new Request.Builder().url(url).put((RequestBody)body).build();
        okhttp3.Response response = null;
        try {
            response = PostJsonUtil.getHttpClient().newCall(request).execute();
        }
        finally {
            if (null != response) {
                response.close();
            }
        }
    }

    private static class HttpClientInstance {
        private static OkHttpClient HTTP_CLIENT = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).connectionPool(new ConnectionPool(5, 1L, TimeUnit.MINUTES)).build();

        private HttpClientInstance() {
        }
    }
}

