/*
 * Decompiled with CFR 0.152.
 */
package com.job.callback;

import com.job.cache.JobMethod;
import com.job.cache.MethodCache;
import com.job.http.Response;
import com.job.model.ReceiptDto;
import java.lang.reflect.Method;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"job"})
public class JobRestController {
    private static final Logger logger = LoggerFactory.getLogger(JobRestController.class);
    private static final ThreadPoolExecutor callbackThredPool = new ThreadPoolExecutor(2 * Runtime.getRuntime().availableProcessors(), 4 * Runtime.getRuntime().availableProcessors(), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(10000), r -> new Thread(r, "job callbackThread_" + r.hashCode()));

    @PostMapping(value={"callback/{callbackName}"})
    @ResponseBody
    public Response callback(@PathVariable String callbackName, @RequestBody ReceiptDto receiptDto) {
        JobMethod jobMethod = MethodCache.get(callbackName);
        if (jobMethod == null) {
            return Response.createError("\u6ca1\u6709\u627e\u5230\u4f5c\u4e1a\u6267\u884c\u7684\u65b9\u6cd5!");
        }
        callbackThredPool.execute(() -> {
            Object methodInstance = null;
            try {
                Method method = jobMethod.getClazz().getDeclaredMethod(jobMethod.getMethod().getName(), ReceiptDto.class);
                if (method == null) {
                    logger.warn("\u6ca1\u6709\u627e\u5230\u4f5c\u4e1a\u65b9\u6cd5\uff0c\u8bf7\u786e\u8ba4\u65b9\u6cd5\u662f\u5426\u5df2\u7ecf\u53d6\u6d88!");
                    return;
                }
                methodInstance = jobMethod.instance();
                if (methodInstance == null) {
                    logger.warn("\u4f5c\u4e1a\u65b9\u6cd5\u7c7b\u5b9e\u4f8b\u5316\u5931\u8d25");
                    return;
                }
                long start = System.currentTimeMillis();
                method.invoke(methodInstance, receiptDto);
                logger.info("\u8c03\u7528\uff1a{} \u8017\u65f6\uff1a{}\uff0c \u53c2\u6570\uff1a{}", new Object[]{callbackName, System.currentTimeMillis() - start, receiptDto});
            }
            catch (Exception e) {
                logger.error("\u901a\u8fc7\u53cd\u5c04\u83b7\u53d6\u4f5c\u4e1a\u65b9\u6cd5\u5931\u8d25\uff0c\u539f\u56e0\uff1a", (Throwable)e);
            }
        });
        return Response.createSuccess("\u4f5c\u4e1a\u8c03\u5ea6\u6210\u529f!");
    }
}

