/*
 * Decompiled with CFR 0.152.
 */
package com.cache.boot.localcache;

import com.cache.boot.localcache.CacheEntity;
import com.cache.redis.util.ObjectUtil;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class CacheExpirationAlgorithm {
    public static CacheEntity expirationAlgorithm(List<CacheEntity> values) {
        if (ObjectUtil.isEmpty(values)) {
            return null;
        }
        Iterator<CacheEntity> i = values.iterator();
        CacheEntity entity = i.next();
        while (i.hasNext()) {
            CacheEntity next = i.next();
            if (next.getHitCount() < entity.getHitCount()) {
                entity = next;
                continue;
            }
            if (next.getHitCount() != entity.getHitCount()) continue;
            entity = CacheExpirationAlgorithm.getNearExpireEntity(entity, next);
        }
        return entity;
    }

    private static CacheEntity getNearExpireEntity(CacheEntity entity, CacheEntity next) {
        if (CacheExpirationAlgorithm.getNearExpire(next) < CacheExpirationAlgorithm.getNearExpire(entity)) {
            entity = next;
        } else if (CacheExpirationAlgorithm.getNearExpire(next) == CacheExpirationAlgorithm.getNearExpire(entity)) {
            entity = CacheExpirationAlgorithm.getLessExpireEntity(entity, next);
        }
        return entity;
    }

    private static CacheEntity getLessExpireEntity(CacheEntity entity, CacheEntity next) {
        if (next.getExpireTime() < entity.getExpireTime()) {
            entity = next;
        } else if (next.getExpireTime() == entity.getExpireTime()) {
            entity = CacheExpirationAlgorithm.getEarlyAccessEntity(entity, next);
        }
        return entity;
    }

    private static CacheEntity getEarlyAccessEntity(CacheEntity entity, CacheEntity next) {
        if (next.getAccessTime() < entity.getAccessTime()) {
            entity = next;
        }
        return entity;
    }

    private static long getNearExpire(CacheEntity entity) {
        return entity.getCreateTime() + TimeUnit.SECONDS.toMillis(entity.getExpireTime());
    }
}

