/*
 * Decompiled with CFR 0.152.
 */
package com.cache.boot.localcache;

import com.cache.boot.localcache.AbstractCacheUtil;
import com.cache.boot.localcache.BaseCache;
import com.cache.boot.localcache.CacheEntity;
import com.cache.boot.localcache.CacheExpirationAlgorithm;
import com.cache.exception.CacheException;
import com.cache.redis.util.ObjectUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public abstract class BaseCacheUtil
extends AbstractCacheUtil
implements BaseCache {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final int DEFAULT_MAX_SIZE = 1000;
    protected static ConcurrentHashMap<String, CacheEntity> cacheCenter = new ConcurrentHashMap(1000);
    private final AtomicBoolean STARTER = new AtomicBoolean(false);

    @Override
    public void put(String key, Object value, long expire) throws CacheException {
        if (StringUtils.isEmpty((Object)key) || StringUtils.isEmpty((Object)value)) {
            this.logger.warn(" CacheUtil put -> key :{} or value :{}  can not be empty .", (Object)key, value);
            return;
        }
        CacheEntity cache = new CacheEntity();
        if (cacheCenter.containsKey(key)) {
            cache = cacheCenter.get(key);
            cache.setHitCount(cache.getHitCount() + 1);
            this.setProperty(cache, value, expire);
        } else {
            cache.setKey(key);
            cache.setHitCount(1);
            this.setProperty(cache, value, expire);
            cacheCenter.put(key, cache);
            this.checkCache();
        }
    }

    @Override
    public Object get(String key) throws CacheException {
        if (StringUtils.isEmpty((Object)key)) {
            this.logger.warn(" CacheUtil get -> key :{}  can not be empty .", (Object)key);
            return null;
        }
        if (cacheCenter.isEmpty() || !cacheCenter.containsKey(key)) {
            return null;
        }
        CacheEntity cache = cacheCenter.get(key);
        if (cache == null) {
            return null;
        }
        cache.setHitCount(cache.getHitCount() + 1);
        cache.setAccessTime(System.currentTimeMillis());
        return cache.getValue();
    }

    @Override
    public Object getAndCompensation(String key) throws CacheException {
        Object result = this.get(key);
        if (result != null) {
            return result;
        }
        return this.compensation(key);
    }

    @Override
    public int del(List<String> keys) throws CacheException {
        if (ObjectUtil.isEmpty(keys)) {
            return 0;
        }
        int delCount = 0;
        for (int i = 0; i < keys.size(); ++i) {
            delCount += cacheCenter.remove(keys.get(i)) != null ? 1 : 0;
        }
        return delCount;
    }

    @Override
    public void delAll() throws CacheException {
        cacheCenter.clear();
    }

    @Override
    public List<String> getKeys() throws CacheException {
        if (ObjectUtil.isEmpty(cacheCenter)) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(cacheCenter.keySet());
    }

    private void setProperty(CacheEntity cache, Object value, long expire) {
        cache.setCreateTime(System.currentTimeMillis());
        cache.setAccessTime(System.currentTimeMillis());
        cache.setExpireTime(expire);
        cache.setValue(value);
    }

    private void checkCache() {
        if (this.isFull()) {
            String kickedKey = this.getKickedKey();
            if (kickedKey != null) {
                cacheCenter.remove(kickedKey);
            } else {
                this.removeByMinUsed();
            }
        }
    }

    private void removeByMinUsed() {
        CacheEntity minUsed = CacheExpirationAlgorithm.expirationAlgorithm(new ArrayList<CacheEntity>(cacheCenter.values()));
        String kickedKey = minUsed.getKey();
        if (kickedKey != null) {
            cacheCenter.remove(kickedKey);
            this.logger.warn("Cache count is reach MAX_SIZE, now delete key :{} by MinUsed ", (Object)kickedKey);
        }
    }

    private boolean isFull() {
        return this.maxSize <= 0 ? cacheCenter.size() >= 1000 : cacheCenter.size() >= this.maxSize;
    }

    protected BaseCacheUtil() {
        if (this.STARTER.compareAndSet(false, true)) {
            this.setMaxSize(1000);
            new Thread(new TimeoutTimerThread()).start();
        }
    }

    class TimeoutTimerThread
    implements Runnable {
        TimeoutTimerThread() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        TimeUnit.SECONDS.sleep(60L);
                        this.expireCache();
                    }
                }
                catch (Exception e) {
                    BaseCacheUtil.this.logger.error(" key is expired ,delete happen error ,see :{} ", (Throwable)e);
                    continue;
                }
                break;
            }
        }

        private void expireCache() throws CacheException {
            for (Map.Entry<String, CacheEntity> entry : cacheCenter.entrySet()) {
                CacheEntity cache = cacheCenter.get(entry.getKey());
                long timoutTime = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - cache.getCreateTime());
                if (cache.getExpireTime() > timoutTime) continue;
                cacheCenter.remove(entry.getKey());
                BaseCacheUtil.this.logger.warn(" key :{}  is deleted because it is expired .", (Object)entry.getKey());
                BaseCacheUtil.this.callBackAfterExpire(entry.getKey(), entry.getValue());
            }
        }
    }
}

