/*
 * Decompiled with CFR 0.152.
 */
package com.cache.boot.config;

import com.cache.boot.config.CompatibleConfig;
import com.cache.redis.CachePoolFactory;
import com.cache.redis.CacheType;
import com.cache.redis.config.CacheConfig;
import com.cache.redis.handelr.factory.CacheHandlerFactory;
import com.cache.utils.CacheUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;
import redis.clients.jedis.HostAndPort;

public class MultiDataSourceConfig {
    private static final Logger log = LoggerFactory.getLogger(MultiDataSourceConfig.class);
    private static final String MULTI_DATASOURCE_NAME_SPACE = "Cache.datasource.instances";
    private static final String MULTI_DATASOURCE_PRIFX = "Cache.datasource.";
    private static final String S_APPLICATION_NAME = "spring.application.name";
    private static final String D_APPLICATION_NAME = "dubbo.application.name";

    public static List<CacheUtils> initCache(ApplicationContext applicationContext) {
        List<CacheConfig> configs = MultiDataSourceConfig.getCacheConfig(applicationContext);
        ArrayList<CacheUtils> cacheServices = new ArrayList<CacheUtils>();
        if (CollectionUtils.isEmpty(configs)) {
            log.warn("T3cache: No config available, please check the config or injection config ...");
            return cacheServices;
        }
        for (CacheConfig config : configs) {
            if (configs.size() == 1) {
                config.setMasterOrSlave("main");
            }
            CachePoolFactory factory = new CachePoolFactory(config);
            factory.buildPool(CacheType.get((Integer)config.getType()));
            CacheUtils cache = CacheUtils.getInstance((CachePoolFactory)factory);
            cacheServices.add(cache);
        }
        try {
            CacheHandlerFactory.getInstance().initCacheHandlersByConfig(configs);
        }
        catch (Exception e) {
            log.error("Init CacheHandlers By Config happen error , Cache init was interrupted ,see :{} .", (Throwable)e);
            return null;
        }
        return cacheServices;
    }

    private static List<CacheConfig> getCacheConfig(ApplicationContext applicationContext) {
        List<CacheConfig> cacheConfigs = MultiDataSourceConfig.initDataSourceByEnv(applicationContext);
        CacheConfig redisCacheConfig = CompatibleConfig.initCacheConfig(applicationContext);
        if (redisCacheConfig != null) {
            cacheConfigs.add(redisCacheConfig);
        }
        return cacheConfigs;
    }

    private static List<CacheConfig> initDataSourceByEnv(ApplicationContext applicationContext) {
        String[] cacheProps;
        Environment environment = applicationContext.getEnvironment();
        ArrayList<CacheConfig> configs = new ArrayList<CacheConfig>();
        String cacheProp = environment.getProperty(MULTI_DATASOURCE_NAME_SPACE);
        if (StringUtils.isEmpty((CharSequence)cacheProp)) {
            return MultiDataSourceConfig.initDataSourceByEnvForOldConfig(environment);
        }
        for (String prop : cacheProps = cacheProp.split(",")) {
            String prix = MULTI_DATASOURCE_PRIFX + prop + ".";
            CacheConfig cacheConfig = MultiDataSourceConfig.bulidCacheConfig(prop, environment, prix);
            configs.add(cacheConfig);
        }
        return configs;
    }

    private static CacheConfig bulidCacheConfig(String prop, Environment environment, String prix) {
        CacheConfig cacheConfig = new CacheConfig();
        cacheConfig.setKey(prop);
        cacheConfig.setHostName(environment.getProperty(prix + "host", ""));
        cacheConfig.setPort(Integer.valueOf(Integer.parseInt(environment.getProperty(prix + "port", "6379"))));
        cacheConfig.setDatabase(Integer.valueOf(Integer.parseInt(environment.getProperty(prix + "database", "0"))));
        cacheConfig.setPassword(environment.getProperty(prix + "password", ""));
        cacheConfig.setType(Integer.valueOf(Integer.parseInt(environment.getProperty(prix + "type", "1"))));
        cacheConfig.setTimeout(Integer.valueOf(Integer.parseInt(environment.getProperty(prix + "timeout", "2000"))));
        cacheConfig.setPipelineThreadMax(Integer.valueOf(Integer.parseInt(environment.getProperty(prix + "pipelineThreadMax", "30"))));
        cacheConfig.setMasterOrSlave(environment.getProperty(prix + "masterOrSlave", ""));
        cacheConfig.setSlaveOf(environment.getProperty(prix + "slaveOf", ""));
        cacheConfig.setSentinelMasterName(environment.getProperty(prix + "sentinel.master", ""));
        cacheConfig.setClusterNodes(MultiDataSourceConfig.getClusterNodes(MultiDataSourceConfig.getSetNodes(environment.getProperty(prix + "cluster.nodes", ""))));
        cacheConfig.setSentinelSet(MultiDataSourceConfig.getSetNodes(environment.getProperty(prix + "sentinel.nodes", "")));
        cacheConfig.setCodisProxyPath(environment.getProperty(prix + "codis.proxy-path", ""));
        cacheConfig.setCodisZookeeper(environment.getProperty(prix + "codis.zookeeper", ""));
        cacheConfig.setTestOnBorrow(Boolean.valueOf(Boolean.parseBoolean(environment.getProperty(prix + "testOnBorrow", "false"))));
        cacheConfig.setTestOnReturn(Boolean.valueOf(Boolean.parseBoolean(environment.getProperty(prix + "testOnReturn", "false"))));
        cacheConfig.setTestWhileIdle(Boolean.valueOf(Boolean.parseBoolean(environment.getProperty(prix + "testWhileIdle", "true"))));
        cacheConfig.setMaxActive(Integer.valueOf(Integer.parseInt(environment.getProperty(prix + "jedis.pool.max-active", "69"))));
        cacheConfig.setMaxIdle(Integer.valueOf(Integer.parseInt(environment.getProperty(prix + "jedis.pool.max-idle", "64"))));
        cacheConfig.setMinIdle(Integer.valueOf(Integer.parseInt(environment.getProperty(prix + "jedis.pool.min-idle", "64"))));
        cacheConfig.setMaxWaitMillis(Integer.valueOf(Integer.parseInt(environment.getProperty(prix + "jedis.pool.max-wait-millis", "2000"))));
        cacheConfig.setMaxQPS(Integer.valueOf(Integer.parseInt(environment.getProperty(prix + "jedis.pool.max-qps", "1000"))));
        cacheConfig.setCacheHandlers(environment.getProperty(prix + "handlers"));
        return cacheConfig;
    }

    private static List<CacheConfig> initDataSourceByEnvForOldConfig(Environment environment) {
        String[] cacheProps;
        String pfi = "Cache.";
        String applicationName = MultiDataSourceConfig.getApplicationName(environment);
        ArrayList<CacheConfig> configs = new ArrayList<CacheConfig>();
        String cacheProp = environment.getProperty(pfi + applicationName + ".instances");
        if (StringUtils.isEmpty((CharSequence)cacheProp)) {
            return configs;
        }
        for (String prop : cacheProps = cacheProp.split(",")) {
            String prix = pfi + applicationName + "." + prop + ".";
            CacheConfig cacheConfig = MultiDataSourceConfig.bulidCacheConfig(prop, environment, prix);
            configs.add(cacheConfig);
        }
        return configs;
    }

    private static String getApplicationName(Environment environment) {
        String applicationName = environment.getProperty(S_APPLICATION_NAME);
        return StringUtils.isEmpty((CharSequence)applicationName) ? environment.getProperty(D_APPLICATION_NAME) : applicationName;
    }

    private static Set<String> getSetNodes(String node) {
        if (StringUtils.isBlank((CharSequence)node)) {
            return Collections.emptySet();
        }
        return new HashSet<String>(MultiDataSourceConfig.getStringSet(node));
    }

    private static List<String> getStringSet(String v) {
        if (StringUtils.isBlank((CharSequence)v)) {
            return Collections.emptyList();
        }
        return Arrays.asList(v.trim().split(","));
    }

    private static Set<HostAndPort> getClusterNodes(Set<String> setString) {
        HashSet<HostAndPort> setClusterNodes = new HashSet<HostAndPort>();
        if (!CollectionUtils.isEmpty(setString)) {
            for (String node : setString) {
                HostAndPort hap = HostAndPort.parseString((String)node);
                setClusterNodes.add(hap);
            }
        }
        return setClusterNodes;
    }
}

