/*
 * Decompiled with CFR 0.152.
 */
package com.cache.boot.config;

import com.cache.redis.config.CacheConfig;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;

public class CompatibleConfig {
    public static final String DEFAULT_KEY = "redis";
    private static final String DEFAULT_PRIFXX = "spring.redis.";

    public static CacheConfig initCacheConfig(ApplicationContext applicationContext) {
        Environment environment = applicationContext.getEnvironment();
        String type = environment.getProperty("spring.redis.type", "1");
        CacheConfig cacheConfig = new CacheConfig();
        if ("1".equals(type)) {
            if (!environment.containsProperty("spring.redis.host")) {
                return null;
            }
            cacheConfig.setType(Integer.valueOf(type));
            cacheConfig.setKey(DEFAULT_KEY);
            cacheConfig.setHostName(environment.getProperty("spring.redis.host", ""));
            cacheConfig.setPort(Integer.valueOf(Integer.parseInt(environment.getProperty("spring.redis.port", "6379"))));
            cacheConfig.setDatabase(Integer.valueOf(Integer.parseInt(environment.getProperty("spring.redis.database", "0"))));
            cacheConfig.setPassword(environment.getProperty("spring.redis.password"));
            cacheConfig.setTimeout(Integer.valueOf(Integer.parseInt(environment.getProperty("spring.redis.timeout", "2000"))));
            cacheConfig.setPipelineThreadMax(Integer.valueOf(Integer.parseInt(environment.getProperty("spring.redis.pipelineThreadMax", "30"))));
            cacheConfig.setMaxActive(Integer.valueOf(Integer.parseInt(environment.getProperty("spring.redis.jedis.pool.max-active", "69"))));
            cacheConfig.setMaxIdle(Integer.valueOf(Integer.parseInt(environment.getProperty("spring.redis.jedis.pool.max-idle", "64"))));
            cacheConfig.setMinIdle(Integer.valueOf(Integer.parseInt(environment.getProperty("spring.redis.jedis.pool.min-idle", "64"))));
            cacheConfig.setMaxWaitMillis(Integer.valueOf(Integer.parseInt(environment.getProperty("spring.redis.jedis.pool.max-wait-millis", "2000"))));
            cacheConfig.setMaxQPS(Integer.valueOf(Integer.parseInt(environment.getProperty("spring.redis.jedis.pool.max-qps", "1000"))));
            cacheConfig.setCacheHandlers(environment.getProperty("spring.redis.handlers"));
        } else if ("2".equals(type)) {
            cacheConfig.setType(Integer.valueOf(type));
            cacheConfig.setKey(DEFAULT_KEY);
            String sentinelMasterName = environment.getProperty("spring.redis.sentinel.master", "");
            if (StringUtils.isBlank((CharSequence)sentinelMasterName)) {
                throw new RuntimeException("\u5f53\u524d\u662fredis\u7684sentinel\u96c6\u7fa4\uff0c\u8bf7\u914d\u7f6esentinel.master\uff01");
            }
            cacheConfig.setSentinelMasterName(sentinelMasterName.trim());
            String sentinelAddress = environment.getProperty("spring.redis.sentinel.nodes", "");
            if (StringUtils.isBlank((CharSequence)sentinelAddress)) {
                throw new RuntimeException("\u5f53\u524d\u662fredis\u7684sentinel\u96c6\u7fa4\uff0c\u8bf7\u914d\u7f6esentinel.nodes\uff01\u914d\u7f6e\u793a\u4f8b\uff1asentinel.nodes: '10.166.2.18:26379,10.166.2.11:26379,10.166.2.12:26379' ");
            }
            cacheConfig.setSentinelSet(CompatibleConfig.getSetNodes(sentinelAddress));
            cacheConfig.setPassword(environment.getProperty("spring.redis.password"));
            cacheConfig.setTimeout(Integer.valueOf(Integer.parseInt(environment.getProperty("spring.redis.timeout", "2000"))));
            cacheConfig.setPipelineThreadMax(Integer.valueOf(Integer.parseInt(environment.getProperty("spring.redis.pipelineThreadMax", "30"))));
            cacheConfig.setMaxActive(Integer.valueOf(Integer.parseInt(environment.getProperty("spring.redis.jedis.pool.max-active", "69"))));
            cacheConfig.setMaxIdle(Integer.valueOf(Integer.parseInt(environment.getProperty("spring.redis.jedis.pool.max-idle", "64"))));
            cacheConfig.setMinIdle(Integer.valueOf(Integer.parseInt(environment.getProperty("spring.redis.jedis.pool.min-idle", "64"))));
            cacheConfig.setMaxWaitMillis(Integer.valueOf(Integer.parseInt(environment.getProperty("spring.redis.jedis.pool.max-wait-millis", "2000"))));
            cacheConfig.setMaxQPS(Integer.valueOf(Integer.parseInt(environment.getProperty("spring.redis.jedis.pool.max-qps", "1000"))));
            cacheConfig.setCacheHandlers(environment.getProperty("spring.redis.handlers"));
        } else {
            throw new RuntimeException("redis cluster \u96c6\u7fa4\u6682\u4e0d\u652f\u6301\uff01\u5982\u9700\u8981\u4f7f\u7528\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4e2d\u53f0\uff0c\u5f00\u653e\u8be5\u96c6\u7fa4\u7684\u652f\u6301\u7248\u672c\uff01");
        }
        return cacheConfig;
    }

    private static Set<String> getSetNodes(String node) {
        if (StringUtils.isBlank((CharSequence)node)) {
            return Collections.emptySet();
        }
        return new HashSet<String>(CompatibleConfig.getStringSet(node));
    }

    private static List<String> getStringSet(String v) {
        if (StringUtils.isBlank((CharSequence)v)) {
            return Collections.emptyList();
        }
        return Arrays.asList(v.trim().split(","));
    }
}

