/*
 * Decompiled with CFR 0.152.
 */
package com.cache.boot;

import com.cache.CacheFactory;
import com.cache.boot.RegisterBean;
import com.cache.boot.config.MultiDataSourceConfig;
import com.cache.local.guava.service.GuavaCacheService;
import com.cache.local.guava.service.impl.GuavaCacheServiceImpl;
import com.cache.redis.CacheService;
import com.cache.redis.util.ObjectUtil;
import com.cache.service.IBloomFilterService;
import com.cache.service.IExpireGeoValueService;
import com.cache.service.IExpireHashService;
import com.cache.service.IExpireListService;
import com.cache.service.IExpireSetService;
import com.cache.service.IExpireSortSetService;
import com.cache.service.IExpireStringService;
import com.cache.service.IGeoValueService;
import com.cache.service.IHashService;
import com.cache.service.IInternalService;
import com.cache.service.IListService;
import com.cache.service.ILockService;
import com.cache.service.IRedisService;
import com.cache.service.ISetService;
import com.cache.service.ISortSetService;
import com.cache.service.IStringService;
import com.cache.service.impl.BloomFilterServiceImpl;
import com.cache.service.impl.ExpireGeoValueServiceImpl;
import com.cache.service.impl.ExpireHashServiceImpl;
import com.cache.service.impl.ExpireListServiceImpl;
import com.cache.service.impl.ExpireSetServiceImpl;
import com.cache.service.impl.ExpireSortSetServiceImpl;
import com.cache.service.impl.ExpireStringServiceImpl;
import com.cache.service.impl.GeoValueServiceImpl;
import com.cache.service.impl.HashServiceImpl;
import com.cache.service.impl.InternalServiceImpl;
import com.cache.service.impl.ListServiceImpl;
import com.cache.service.impl.LockServiceImpl;
import com.cache.service.impl.SetServiceImpl;
import com.cache.service.impl.SortSetServiceImpl;
import com.cache.service.impl.StringServiceImpl;
import com.cache.utils.CacheUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CacheBootConfig
implements BeanFactoryPostProcessor,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(CacheBootConfig.class);
    private static final String SERVICE_BEAN_NAMES = "ILockService,IStringService,IListService,IHashService,ISetService,ISortSetService,IGeoValueService,IExpireStringService,IExpireListService,IExpireHashService,IExpireSetService,IExpireSortSetService,IExpireGeoValueService,IInternalService,IBloomFilterService";
    private static final String BASE_SERVICE_NAME = "ICacheService";
    private static ApplicationContext applicationContext;

    public Boolean register(List<CacheUtils> caches) {
        if (ObjectUtil.isEmpty(caches)) {
            log.warn("T3cache: No config available, Beans init failed ... ");
            return false;
        }
        for (CacheUtils cache : caches) {
            this.registerBeansWithKey(cache);
        }
        this.registerGuavaByAutowireName();
        return true;
    }

    private void registerBeansWithKey(CacheUtils cache) {
        try {
            RegisterBean.registerAutowireByName(CacheService.class, Collections.singletonList(cache), cache.getFactory().getConfig().getKey() + BASE_SERVICE_NAME);
            CacheService cacheService = (CacheService)applicationContext.getBean(cache.getFactory().getConfig().getKey() + BASE_SERVICE_NAME, CacheService.class);
            this.registerExtByAutowireName(cacheService, cache.getFactory().getConfig().getKey());
            List<Object> beans = this.getServiceBeansByName(cache.getFactory().getConfig().getKey());
            this.registerCacheFactory(beans, cache.getFactory().getConfig().getKey());
        }
        catch (Exception e) {
            log.error("error found:", (Throwable)e);
        }
    }

    private void registerExtByAutowireName(CacheService cacheService, String key) {
        RegisterBean.registerAutowireByName(ExpireGeoValueServiceImpl.class, Collections.singletonList(cacheService), key + IExpireGeoValueService.class.getSimpleName());
        RegisterBean.registerAutowireByName(ExpireHashServiceImpl.class, Collections.singletonList(cacheService), key + IExpireHashService.class.getSimpleName());
        RegisterBean.registerAutowireByName(ExpireListServiceImpl.class, Collections.singletonList(cacheService), key + IExpireListService.class.getSimpleName());
        RegisterBean.registerAutowireByName(ExpireSetServiceImpl.class, Collections.singletonList(cacheService), key + IExpireSetService.class.getSimpleName());
        RegisterBean.registerAutowireByName(ExpireSortSetServiceImpl.class, Collections.singletonList(cacheService), key + IExpireSortSetService.class.getSimpleName());
        RegisterBean.registerAutowireByName(ExpireStringServiceImpl.class, Collections.singletonList(cacheService), key + IExpireStringService.class.getSimpleName());
        RegisterBean.registerAutowireByName(GeoValueServiceImpl.class, Collections.singletonList(cacheService), key + IGeoValueService.class.getSimpleName());
        RegisterBean.registerAutowireByName(HashServiceImpl.class, Collections.singletonList(cacheService), key + IHashService.class.getSimpleName());
        RegisterBean.registerAutowireByName(ListServiceImpl.class, Collections.singletonList(cacheService), key + IListService.class.getSimpleName());
        RegisterBean.registerAutowireByName(LockServiceImpl.class, Collections.singletonList(cacheService), key + ILockService.class.getSimpleName());
        RegisterBean.registerAutowireByName(SetServiceImpl.class, Collections.singletonList(cacheService), key + ISetService.class.getSimpleName());
        RegisterBean.registerAutowireByName(SortSetServiceImpl.class, Collections.singletonList(cacheService), key + ISortSetService.class.getSimpleName());
        RegisterBean.registerAutowireByName(StringServiceImpl.class, Collections.singletonList(cacheService), key + IStringService.class.getSimpleName());
        RegisterBean.registerAutowireByName(IRedisService.class, Collections.singletonList(cacheService), key + IRedisService.class.getSimpleName());
        RegisterBean.registerAutowireByName(InternalServiceImpl.class, Collections.singletonList(cacheService), key + IInternalService.class.getSimpleName());
        RegisterBean.registerAutowireByName(BloomFilterServiceImpl.class, Collections.singletonList(cacheService), key + IBloomFilterService.class.getSimpleName());
    }

    private void registerGuavaByAutowireName() {
        RegisterBean.registerAutowireByName(GuavaCacheServiceImpl.class, Collections.emptyList(), GuavaCacheService.class.getSimpleName());
    }

    private void registerCacheFactory(List<Object> beans, String key) {
        RegisterBean.registerAutowireByName(CacheFactory.class, beans, key + CacheFactory.class.getSimpleName());
    }

    private List<String> getServiceBeanNames(String key) {
        List<String> names = Arrays.asList(SERVICE_BEAN_NAMES.split(","));
        return names.stream().map(name -> key + name).collect(Collectors.toList());
    }

    private List<Object> getServiceBeansByName(String key) {
        List<String> names = this.getServiceBeanNames(key);
        ArrayList<Object> beans = new ArrayList<Object>();
        for (String name : names) {
            beans.add(applicationContext.getBean(name));
        }
        return beans;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        log.info("begin to register Cache.");
        List<CacheUtils> caches = MultiDataSourceConfig.initCache(applicationContext);
        this.register(caches);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        CacheBootConfig.applicationContext = applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }
}

