/*
 * Decompiled with CFR 0.152.
 */
package com.cache.resp.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.HostAndPort;

public class RespNodesHelper {
    private static final Logger log = LoggerFactory.getLogger(RespNodesHelper.class);
    public static final int DEFAULT_PORT = 9736;
    public static final int TIME_OUT = 2000;

    public static List<HostAndPort> formatNodes(String nodes) {
        if (StringUtils.isEmpty((CharSequence)nodes)) {
            return Collections.emptyList();
        }
        ArrayList<HostAndPort> result = new ArrayList<HostAndPort>();
        String[] partitionsArray = nodes.split(",");
        for (int i = 0; i < partitionsArray.length; ++i) {
            try {
                result.add(HostAndPort.parseString((String)partitionsArray[i]));
                continue;
            }
            catch (IllegalArgumentException e) {
                log.warn("Cache partitions config is irregular, : {}, will use dafault port : {} ", (Object)e.getMessage(), (Object)9736);
                result.add(new HostAndPort(partitionsArray[i], 9736));
            }
        }
        return result;
    }
}

