/*
 * Decompiled with CFR 0.152.
 */
package com.cache.resp.thread;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RespThreadFactory
implements ThreadFactory {
    private static final Logger log = LoggerFactory.getLogger(RespThreadFactory.class);
    private static final AtomicInteger poolNumber = new AtomicInteger(0);
    private final Integer id;
    private final String namePrefix;
    private final AtomicInteger threadNumber = new AtomicInteger(0);

    public RespThreadFactory(String desc) {
        this.id = poolNumber.incrementAndGet();
        this.namePrefix = desc + this.id + "-thread-";
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(r, this.namePrefix + this.threadNumber.incrementAndGet());
        if (t.isDaemon()) {
            t.setDaemon(false);
        }
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        log.info("create Cache resp  thread :{}", (Object)t.getName());
        return t;
    }
}

