/*
 * Decompiled with CFR 0.152.
 */
package com.cache.resp.task;

import com.cache.redis.util.ObjectUtil;
import com.cache.resp.factory.RespClientFactory;
import com.cache.resp.service.alive.BaseRespAliveCallBack;
import com.cache.resp.service.alive.RespAliveService;
import com.github.tonivade.resp.RespCallback;
import com.github.tonivade.resp.RespClient;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RespAliveTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(RespAliveTask.class);
    private static Map<String, RespClient> respClients = RespClientFactory.getRespClients();
    private static Map<String, RespCallback> callbacks = RespClientFactory.getCallback();
    private Map<Integer, String> pingFlags = BaseRespAliveCallBack.pingFlags;
    private final Long aliveInterval;
    private static final Long DEFAULT_INTERVAL = 10000L;

    public RespAliveTask(Long aliveInterval) {
        this.aliveInterval = aliveInterval == null ? DEFAULT_INTERVAL : aliveInterval;
    }

    @Override
    public void run() {
        log.info("Now RespAliveTask Started----------------->>>>>>> ");
        while (true) {
            try {
                while (true) {
                    if (ObjectUtil.isEmpty(respClients)) {
                        continue;
                    }
                    for (Map.Entry<String, RespClient> entry : respClients.entrySet()) {
                        RespAliveService.ping(entry.getValue());
                        BaseRespAliveCallBack respCallback = (BaseRespAliveCallBack)callbacks.get(entry.getKey());
                        String pingTmeFlag = this.pingFlags.get(respCallback.hashCode());
                        String[] pingTmeFlagArray = pingTmeFlag.split("_");
                        if (Boolean.TRUE.equals(pingTmeFlagArray[1])) {
                            this.recordAliveStatus(entry.getKey(), pingTmeFlagArray[0]);
                            continue;
                        }
                        BaseRespAliveCallBack.respStatus.getIsAlive().put(entry.getKey(), false);
                    }
                    Thread.currentThread();
                    Thread.sleep(this.aliveInterval);
                }
            }
            catch (Exception e) {
                log.error("resp \u63a2\u6d3b\u4efb\u52a1\u53d1\u751f\u5f02\u5e38\uff0csee :{} .", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private void recordAliveStatus(String host, String pingTme) {
        Long lastUpdateTime = Long.valueOf(pingTme);
        if (BaseRespAliveCallBack.respStatus.getLastConnectionTime().get(host) == null || lastUpdateTime + this.aliveInterval + 2000L >= System.currentTimeMillis()) {
            BaseRespAliveCallBack.respStatus.getIsAlive().put(host, true);
        } else if (lastUpdateTime + this.aliveInterval + 2000L < System.currentTimeMillis()) {
            BaseRespAliveCallBack.respStatus.getIsAlive().put(host, false);
        }
        BaseRespAliveCallBack.respStatus.getLastConnectionTime().put(host, System.currentTimeMillis());
    }
}

