/*
 * Decompiled with CFR 0.152.
 */
package com.cache.resp.service.expire;

import com.cache.local.guava.service.CacheConfig;
import com.cache.redis.util.ObjectUtil;
import com.cache.resp.service.alive.BaseRespAliveCallBack;
import com.cache.resp.service.expire.BaseRespNotifyService;
import com.cache.resp.thread.RespThreadFactory;
import com.github.tonivade.resp.RespClient;
import com.github.tonivade.resp.protocol.RedisToken;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;

public class RespNotifyService
extends BaseRespNotifyService {
    private static final String NOTIFY_DESC = "Cache-resp-expire-notify-";
    private static AtomicBoolean INIT = new AtomicBoolean(false);
    protected static ExecutorService respNotifyService;

    private RespNotifyService() {
    }

    public static RespNotifyService getInstance(String nodes) {
        RespNotifyService.initNotifyService(nodes);
        return SingletonInner.respNotifyService;
    }

    public static RespNotifyService getInstance() {
        return SingletonInner.respNotifyService;
    }

    private static void initNotifyService(String nodes) {
        if (INIT.compareAndSet(false, true) && !StringUtils.isEmpty((CharSequence)nodes) && nodes.split(",").length - 1 > 0) {
            respNotifyService = RespNotifyService.newCachedThreadPool(nodes.split(",").length - 1, new RespThreadFactory(NOTIFY_DESC));
        }
    }

    private static ExecutorService newCachedThreadPool(int threadNum, ThreadFactory factory) {
        return Executors.newFixedThreadPool(threadNum, factory);
    }

    public void notifyOtherNodesAfterDel(CacheConfig config, String key) {
        RedisToken expireCommand = this.bulidCommand(config, key);
        if (!ObjectUtil.isEmpty((Map)respClients) && INIT.get()) {
            for (Map.Entry entry : respClients.entrySet()) {
                if (!Boolean.TRUE.equals(BaseRespAliveCallBack.respStatus.getIsAlive().get(entry.getKey()))) continue;
                RespNotifyService.expire((RespClient)entry.getValue(), expireCommand);
            }
        }
    }

    private RedisToken bulidCommand(CacheConfig config, String key) {
        String nameSpace = config.getNameSpace();
        String table = config.getTable();
        return RedisToken.array((RedisToken[])new RedisToken[]{RedisToken.string((String)"EXPIRE"), RedisToken.string((String)nameSpace), RedisToken.string((String)table), RedisToken.string((String)key)});
    }

    public static RedisToken expire(final RespClient respClient, final RedisToken params) {
        Callable<RedisToken> runnable = new Callable<RedisToken>(){

            @Override
            public RedisToken call() {
                try {
                    respClient.send(params);
                }
                catch (Exception e) {
                    BaseRespNotifyService.log.error("PING-->request happen error,see :{} ", (Throwable)e);
                    return RedisToken.string((String)"EXPIRE_ERROR");
                }
                return RedisToken.string((String)"EXPIRE_SUCCESS");
            }
        };
        return RespNotifyService.submit(runnable, respNotifyService, 2000L);
    }

    private static class SingletonInner {
        private static RespNotifyService respNotifyService = new RespNotifyService();

        private SingletonInner() {
        }
    }
}

