/*
 * Decompiled with CFR 0.152.
 */
package com.cache.resp.service.expire;

import com.cache.resp.factory.RespClientFactory;
import com.cache.resp.service.RespService;
import com.cache.resp.service.expire.BaseRespExpireCallBack;
import com.github.tonivade.resp.RespClient;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseRespNotifyService
extends BaseRespExpireCallBack
implements RespService {
    protected static final Logger log = LoggerFactory.getLogger(BaseRespNotifyService.class);
    protected static Map<String, RespClient> respClients = RespClientFactory.getRespClients();

    public static <T> T submit(Callable<T> call, ExecutorService respService, long timeOut) {
        Future<T> result = respService.submit(call);
        T t = null;
        try {
            t = result.get(timeOut, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("respService get result happen InterruptedException..see :{}", (Throwable)e);
        }
        catch (TimeoutException e) {
            log.error("respService get result happen TimeoutException..see :{}", (Throwable)e);
        }
        catch (ExecutionException e) {
            log.error("respService get result happen ExecutionException..see :{}", (Throwable)e);
        }
        return t;
    }
}

