/*
 * Decompiled with CFR 0.152.
 */
package com.cache.resp.service.alive;

import com.cache.redis.util.ObjectUtil;
import com.cache.resp.service.alive.BaseRespAliveService;
import com.cache.resp.status.RespStatus;
import com.cache.resp.task.RespAliveTask;
import com.cache.resp.thread.RespThreadFactory;
import com.cache.resp.utils.ServerHelper;
import com.github.tonivade.resp.RespClient;
import com.github.tonivade.resp.protocol.RedisToken;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;

public class RespAliveService
extends BaseRespAliveService {
    private static final String ALIVE_DESC = "Cache-resp-alive-";
    private static AtomicBoolean STARTER = new AtomicBoolean(false);
    private static AtomicBoolean INIT = new AtomicBoolean(false);
    private static ExecutorService respAliveService;

    private RespAliveService() {
    }

    public static RespAliveService getInstance(String nodes) {
        if (INIT.compareAndSet(false, true) && !StringUtils.isEmpty((CharSequence)nodes) && nodes.split(",").length - 1 > 0) {
            respAliveService = RespAliveService.newCachedThreadPool(nodes.split(",").length - 1, new RespThreadFactory(ALIVE_DESC));
        }
        return SingletonInner.respAliveService;
    }

    public static RespAliveService getInstance() {
        return SingletonInner.respAliveService;
    }

    private static ExecutorService newCachedThreadPool(int threadNum, ThreadFactory factory) {
        return Executors.newFixedThreadPool(threadNum, factory);
    }

    public void start(Long aliveInterval) {
        if (STARTER.compareAndSet(false, true)) {
            if (!ObjectUtil.isEmpty((Map)respClients)) {
                for (Map.Entry entry : respClients.entrySet()) {
                    ((RespClient)entry.getValue()).start();
                    log.info("Now resp client service is started, server ip is :{}  ", entry.getKey());
                }
                RespAliveService.initRespStatus();
            }
            new Thread(new RespAliveTask(aliveInterval)).start();
        }
    }

    public static RedisToken ping(final RespClient respClient) {
        Callable<RedisToken> runnable = new Callable<RedisToken>(){

            @Override
            public RedisToken call() {
                try {
                    respClient.send(RedisToken.array((RedisToken[])new RedisToken[]{RedisToken.string((String)"PING")}));
                }
                catch (Exception e) {
                    BaseRespAliveService.log.error("PING-->request happen error,see :{} ", (Throwable)e);
                    return RedisToken.string((String)"ERROR");
                }
                return RedisToken.string((String)"SUCCESS");
            }
        };
        return RespAliveService.submit(runnable, respAliveService, 2000L);
    }

    private static RespStatus initRespStatus() {
        if (respStatus == null) {
            respStatus = new RespStatus();
            respStatus.setCurrentNode(ServerHelper.getInstance().getServerHost());
            respStatus.setOrtherNodes(new ArrayList<String>(respClients.keySet()));
        }
        return respStatus;
    }

    private static class SingletonInner {
        private static RespAliveService respAliveService = new RespAliveService();

        private SingletonInner() {
        }
    }
}

