/*
 * Decompiled with CFR 0.152.
 */
package com.cache.resp.factory;

import com.cache.redis.util.ObjectUtil;
import com.cache.resp.command.LocalCommandSuite;
import com.cache.resp.utils.RespNodesHelper;
import com.cache.resp.utils.ServerHelper;
import com.github.tonivade.resp.RespServer;
import com.github.tonivade.resp.RespServerContext;
import com.github.tonivade.resp.command.CommandSuite;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import redis.clients.jedis.HostAndPort;

public class RespServerFactory {
    private static RespServer respServer;
    private static AtomicBoolean STARTER;
    static CommandSuite commandSuite;

    private RespServerFactory() {
    }

    public static RespServerFactory getInstance() {
        return SingletonInner.respServerFactory;
    }

    public void startRespServer(String nodes) {
        if (respServer == null && STARTER.compareAndSet(false, true)) {
            respServer = RespServerFactory.initRespServer(nodes);
        }
        if (respServer != null && STARTER.get()) {
            respServer.start();
        }
    }

    public static void shutRespServer() {
        if (respServer != null) {
            respServer.stop();
        }
    }

    private static RespServer initRespServer(String nodes) {
        List filterHost;
        String serverHost = ServerHelper.getInstance().getServerHost();
        List<HostAndPort> formatNodes = RespNodesHelper.formatNodes(nodes);
        if (!ObjectUtil.isEmpty(formatNodes) && !ObjectUtil.isEmpty(filterHost = formatNodes.stream().filter(h -> h.getHost().equals(serverHost)).collect(Collectors.toList()))) {
            respServer = new RespServer(new RespServerContext(serverHost, ((HostAndPort)filterHost.get(0)).getPort(), RespServerFactory.careteCommandSuite()));
            return respServer;
        }
        return null;
    }

    private static synchronized CommandSuite careteCommandSuite() {
        if (commandSuite == null) {
            commandSuite = new LocalCommandSuite();
        }
        return commandSuite;
    }

    public static CommandSuite getCommandSuite() {
        return RespServerFactory.careteCommandSuite();
    }

    public static RespServer getRespServer() {
        return respServer;
    }

    static {
        STARTER = new AtomicBoolean(false);
    }

    private static class SingletonInner {
        private static RespServerFactory respServerFactory = new RespServerFactory();

        private SingletonInner() {
        }
    }
}

