/*
 * Decompiled with CFR 0.152.
 */
package com.cache.resp.factory;

import com.cache.redis.util.ObjectUtil;
import com.cache.resp.service.alive.BaseRespAliveCallBack;
import com.cache.resp.utils.RespNodesHelper;
import com.cache.resp.utils.ServerHelper;
import com.github.tonivade.resp.RespCallback;
import com.github.tonivade.resp.RespClient;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.HostAndPort;

public class RespClientFactory {
    private static final Logger log = LoggerFactory.getLogger(RespClientFactory.class);
    public static Map<String, RespClient> respClients = new ConcurrentHashMap<String, RespClient>(64);
    private static Map<String, RespCallback> callbacks = new ConcurrentHashMap<String, RespCallback>(64);
    private static AtomicBoolean STARTER = new AtomicBoolean(false);

    private RespClientFactory() {
    }

    public static RespClientFactory getInstance() {
        return SingletonInner.respClientFactory;
    }

    public void initRespClients(String nodes) {
        if (STARTER.compareAndSet(false, true)) {
            List filterHost;
            String serverHost = ServerHelper.getInstance().getServerHost();
            List<HostAndPort> formatNodes = RespNodesHelper.formatNodes(nodes);
            if (!ObjectUtil.isEmpty(formatNodes) && !ObjectUtil.isEmpty(filterHost = formatNodes.stream().filter(h -> !h.getHost().equals(serverHost)).collect(Collectors.toList()))) {
                for (HostAndPort hostAndPort : filterHost) {
                    BaseRespAliveCallBack respCallback = new BaseRespAliveCallBack();
                    RespClient redisClient = new RespClient(hostAndPort.getHost(), hostAndPort.getPort(), (RespCallback)respCallback);
                    respClients.put(hostAndPort.getHost(), redisClient);
                    callbacks.put(hostAndPort.getHost(), respCallback);
                }
                log.info("RespClients  are created,see: {}", respClients);
            }
        }
    }

    public static Map<String, RespClient> getRespClients() {
        return respClients;
    }

    public static Map<String, RespCallback> getCallback() {
        return callbacks;
    }

    private static class SingletonInner {
        private static RespClientFactory respClientFactory = new RespClientFactory();

        private SingletonInner() {
        }
    }
}

