/*
 * Decompiled with CFR 0.152.
 */
package com.cache.resp.command;

import com.cache.exception.CacheException;
import com.cache.resp.task.RespExpireTask;
import com.github.tonivade.resp.annotation.Command;
import com.github.tonivade.resp.annotation.ParamLength;
import com.github.tonivade.resp.command.Request;
import com.github.tonivade.resp.command.RespCommand;
import com.github.tonivade.resp.protocol.RedisToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(value="expire")
@ParamLength(value=3)
public class ExpireCommand
implements RespCommand {
    private static final Logger log = LoggerFactory.getLogger(ExpireCommand.class);
    private static final String EXPIRED = "EXPIRED";
    public static final String EXPIRE = "EXPIRE";
    private static final String ERROR = "ERROR";

    public RedisToken execute(Request request) {
        if (request.getLength() > 0) {
            try {
                RespExpireTask.getInstance().delete(request);
            }
            catch (CacheException e) {
                log.error("del key  by Guava happen error ,see:{}", (Throwable)e);
                return RedisToken.status((String)ERROR);
            }
            return RedisToken.responseOk();
        }
        return RedisToken.status((String)EXPIRED);
    }
}

