package com.cache.resp.utils;

import java.net.InetAddress;
import java.net.UnknownHostException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * 获取服务的ip信息
 * 
 * @author zhuly
 *
 */
public class ServerHelper {
	private static final Logger logger = LoggerFactory.getLogger(ServerHelper.class);
	private String serverHost;
	private static final ServerHelper INSTANCE = new ServerHelper();

	private ServerHelper() {
	}

	public static ServerHelper getInstance() {
		return INSTANCE;
	}

	public String getServerHost() {
		if (serverHost == null) {
			serverHost = getUrl();
		}
		return serverHost;
	}

	private String getUrl() {
		InetAddress address = null;
		try {
			address = InetAddress.getLocalHost();
		} catch (UnknownHostException e) {
			logger.error("error found!", e);
			throw new IllegalArgumentException("服务IP获取异常！");
		}
		return address.getHostAddress();
	}

}
