package com.cache.resp.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import redis.clients.jedis.HostAndPort;

/**
 * 节点配置格式化工具
 * 
 * @author dongjianlei
 *
 */
public class RespNodesHelper {
	private static final Logger log = LoggerFactory.getLogger(RespNodesHelper.class);

	/*** 默认通信端口 ***/
	public static final int DEFAULT_PORT = 9736;

	/*** 默认通信超时时间,2000ms ***/
	public static final int TIME_OUT = 2000;

	/**
	 * 将节点配置信息格式化
	 * 
	 * @return
	 */
	public static List<HostAndPort> formatNodes(String nodes) {
		if (StringUtils.isEmpty(nodes)) {
			return Collections.emptyList();
		}
		List<HostAndPort> result = new ArrayList<>();
		String[] partitionsArray = nodes.split(",");
		for (int i = 0; i < partitionsArray.length; i++) {
			try {
				result.add(HostAndPort.parseString(partitionsArray[i]));
			} catch (IllegalArgumentException e) {
				log.warn("Cache partitions config is irregular, : {}, will use dafault port : {} ", e.getMessage(),
						DEFAULT_PORT);
				// 如果只配置了ip,使用默认端口9736
				result.add(new HostAndPort(partitionsArray[i], DEFAULT_PORT));
			}
		}
		return result;
	}

}
