package com.cache.resp.thread;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 线程工厂类
 * 
 * @author dongjianlei
 *
 */
public class RespThreadFactory implements ThreadFactory {

	private static final Logger log = LoggerFactory.getLogger(RespThreadFactory.class);
	private static final AtomicInteger poolNumber = new AtomicInteger(0);
	private final Integer id;
	private final String namePrefix;
	private final AtomicInteger threadNumber = new AtomicInteger(0);

	public RespThreadFactory(String desc) {
		id = poolNumber.incrementAndGet();
		namePrefix = desc + id + "-thread-";
	}

	@Override
	public Thread newThread(Runnable r) {
		Thread t = new Thread(r, namePrefix + threadNumber.incrementAndGet());

		if (t.isDaemon())
			t.setDaemon(false);

		if (t.getPriority() != Thread.NORM_PRIORITY)
			t.setPriority(Thread.NORM_PRIORITY);

		log.info("create Cache resp  thread :{}", t.getName());
		return t;
	}

}
