package com.cache.resp.task;

import com.cache.exception.CacheException;
import com.cache.local.guava.service.CacheConfig;
import com.cache.local.guava.service.GuavaCacheService;
import com.cache.local.guava.service.impl.GuavaCacheServiceImpl;
import com.github.tonivade.resp.command.Request;

/**
 * key过期同步删除任务
 * 
 * @author dongjianlei
 *
 */
public class RespExpireTask {

	private GuavaCacheService guavaCacheService;

	private static class SingletonInner {
		private static RespExpireTask expireTask = new RespExpireTask();
	}

	public static RespExpireTask getInstance() {
		return SingletonInner.expireTask;
	}

	/**
	 * 调用guavaCacheService 的删除api对key 进行删除操作
	 * 
	 * @param request
	 * @throws CacheException
	 */
	public void delete(Request request) throws CacheException {
		CacheConfig cacheConfig = bulidCacheConfig(request.getParam(0).toString(), request.getParam(1).toString());
		initT3GuavaCacheService().delete(cacheConfig, request.getParam(2).toString());
	}

	private synchronized GuavaCacheService initT3GuavaCacheService() {
		if (guavaCacheService == null) {
			guavaCacheService = new GuavaCacheServiceImpl();
		}
		return guavaCacheService;
	}

	/**
	 * 获取命令携带参数封装成请求参数
	 * 
	 * @param nameSpace
	 * @param table
	 * @return
	 */
	private CacheConfig bulidCacheConfig(String nameSpace, String table) {
		CacheConfig cacheConfig = new CacheConfig();
		cacheConfig.setNameSpace(nameSpace);
		cacheConfig.setTable(table);
		return cacheConfig;
	}
}
