package com.cache.resp.task;

import java.util.Map;
import java.util.Map.Entry;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.cache.redis.util.ObjectUtil;
import com.cache.resp.factory.RespClientFactory;
import com.cache.resp.service.alive.BaseRespAliveCallBack;
import com.cache.resp.service.alive.RespAliveService;
import com.cache.resp.utils.RespNodesHelper;
import com.github.tonivade.resp.RespCallback;
import com.github.tonivade.resp.RespClient;

/**
 * 节点探活任务
 * 
 * @author dongjianlei
 *
 */
public class RespAliveTask implements Runnable {

	private static final Logger log = LoggerFactory.getLogger(RespAliveTask.class);

	private static Map<String, RespClient> respClients = RespClientFactory.getRespClients();

	private static Map<String, RespCallback> callbacks = RespClientFactory.getCallback();

	private Map<Integer, String> pingFlags = BaseRespAliveCallBack.pingFlags;

	private final Long aliveInterval;
	/** 探活间隔,默认10s **/
	private static final Long DEFAULT_INTERVAL = 10000L;

	public RespAliveTask(Long aliveInterval) {
		this.aliveInterval = (aliveInterval == null ? DEFAULT_INTERVAL : aliveInterval);
	}

	@SuppressWarnings("all")
	public void run() {
		log.info("Now RespAliveTask Started----------------->>>>>>> ");
		while (true) {
			try {
				if (!ObjectUtil.isEmpty(respClients)) {
					for (Entry<String, RespClient> entry : respClients.entrySet()) {
						RespAliveService.ping(entry.getValue());
						BaseRespAliveCallBack respCallback = (BaseRespAliveCallBack) callbacks.get(entry.getKey());
						String pingTmeFlag = pingFlags.get(respCallback.hashCode());
						// 如果返回是true，并且距离上次状态更新时间 不大于 探活间隔时间，证明节点是存活的
						String[] pingTmeFlagArray = pingTmeFlag.split(BaseRespAliveCallBack.SEPARATOR);
						if (Boolean.TRUE.equals(pingTmeFlagArray[1])) {
							recordAliveStatus(entry.getKey(), pingTmeFlagArray[0]);
						} else {
							BaseRespAliveCallBack.respStatus.getIsAlive().put(entry.getKey(), false);
						}
					}
					Thread.currentThread().sleep(aliveInterval);
				}
			} catch (Exception e) {
				log.error("resp 探活任务发生异常，see :{} .", e);
			}
		}
	}

	/**
	 * 记录节点存活信息
	 *
	 * @param host
	 * @param respCallback
	 * @param pingTme
	 */
	private void recordAliveStatus(String host, String pingTme) {
		Long lastUpdateTime = Long.valueOf(pingTme);
		// 首次探活,或者距离上次存活的时间没超过 12s ,(正常是间隔10S探活，此处给与2s延迟误差)
		if (BaseRespAliveCallBack.respStatus.getLastConnectionTime().get(host) == null
				|| (lastUpdateTime + aliveInterval + RespNodesHelper.TIME_OUT >= System.currentTimeMillis())) {
			BaseRespAliveCallBack.respStatus.getIsAlive().put(host, true);
		} else if ((lastUpdateTime + aliveInterval + RespNodesHelper.TIME_OUT) < System.currentTimeMillis()) {
			BaseRespAliveCallBack.respStatus.getIsAlive().put(host, false);
		}
		BaseRespAliveCallBack.respStatus.getLastConnectionTime().put(host, System.currentTimeMillis());
	}

}
