package com.cache.resp.status;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 探活服务存储节点状态实体类
 * 
 * @author dongjianlei
 *
 */
public class RespStatus implements Serializable {

	private static final long serialVersionUID = -8703449408986898177L;
	/**
	 * 当前节点ip
	 */
	private String currentNode;

	/**
	 * 其他节点ip
	 */
	private List<String> ortherNodes;
	/**
	 * 其他节点的状态
	 */
	private Map<String, Boolean> isAlive = new HashMap<>();

	/**
	 * 与其他节点最后连接的时间
	 */
	private Map<String, Long> lastConnectionTime = new HashMap<>();;

	public String getCurrentNode() {
		return currentNode;
	}

	public void setCurrentNode(String currentNode) {
		this.currentNode = currentNode;
	}

	public List<String> getOrtherNodes() {
		return ortherNodes;
	}

	public void setOrtherNodes(List<String> ortherNodes) {
		this.ortherNodes = ortherNodes;
	}

	public Map<String, Boolean> getIsAlive() {
		return isAlive;
	}

	public void setIsAlive(Map<String, Boolean> isAlive) {
		this.isAlive = isAlive;
	}

	public Map<String, Long> getLastConnectionTime() {
		return lastConnectionTime;
	}

	public void setLastConnectionTime(Map<String, Long> lastConnectionTime) {
		this.lastConnectionTime = lastConnectionTime;
	}

	@Override
	public String toString() {
		return "RespStatus [currentNode=" + currentNode + ", ortherNodes=" + ortherNodes + ", isAlive=" + isAlive
				+ ", lastConnectionTime=" + lastConnectionTime + "]";
	}

}
