package com.cache.resp.service.expire;

import static com.github.tonivade.resp.protocol.RedisToken.string;

import java.util.Map.Entry;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;

import org.apache.commons.lang3.StringUtils;

import com.cache.local.guava.service.CacheConfig;
import com.cache.redis.util.ObjectUtil;
import com.cache.resp.service.alive.BaseRespAliveCallBack;
import com.cache.resp.thread.RespThreadFactory;
import com.cache.resp.utils.RespNodesHelper;
import com.github.tonivade.resp.RespClient;
import com.github.tonivade.resp.protocol.RedisToken;

/**
 * 强一致性同步服务
 *
 * @author dongjianlei
 */
public class RespNotifyService extends BaseRespNotifyService {

	private static final String NOTIFY_DESC = "Cache-resp-expire-notify-";

	private static AtomicBoolean INIT = new AtomicBoolean(false);

	protected static ExecutorService respNotifyService;

	private RespNotifyService() {
	}

	private static class SingletonInner {
		private static RespNotifyService respNotifyService = new RespNotifyService();
	}

	/**
	 * 线程最大数量根据节点数减1，一个节点分配一个线程
	 */
	public static RespNotifyService getInstance(String nodes) {
		initNotifyService(nodes);
		return SingletonInner.respNotifyService;
	}

	public static RespNotifyService getInstance() {
		return SingletonInner.respNotifyService;
	}

	/**
	 * 初始化缓存更新同步 线程池
	 */
	private static void initNotifyService(String nodes) {
		if (INIT.compareAndSet(false, true) && (!StringUtils.isEmpty(nodes) && nodes.split(",").length - 1 > 0)) {
			respNotifyService = newCachedThreadPool(nodes.split(",").length - 1, new RespThreadFactory(NOTIFY_DESC));
		}
	}

	private static ExecutorService newCachedThreadPool(int threadNum, ThreadFactory factory) {
		return Executors.newFixedThreadPool(threadNum, factory);
	}

	/**
	 * 删除数据后节点通知
	 *
	 * @param config
	 * @param key
	 */
	public void notifyOtherNodesAfterDel(CacheConfig config, String key) {
		RedisToken expireCommand = bulidCommand(config, key);
		if (!ObjectUtil.isEmpty(respClients) && INIT.get()) {
			for (Entry<String, RespClient> entry : respClients.entrySet()) {
				// 根据节点状态， 存活进行通知
				if (Boolean.TRUE.equals(BaseRespAliveCallBack.respStatus.getIsAlive().get(entry.getKey()))) {
					expire(entry.getValue(), expireCommand);
				}
			}
		}
	}

	/**
	 * 构建通知删除的命令及入参
	 * 
	 * @param config
	 * @param key
	 * @return
	 */
	private RedisToken bulidCommand(CacheConfig config, String key) {
		String nameSpace = config.getNameSpace();
		String table = config.getTable();
		return RedisToken.array(RedisToken.string(EXPIRE), RedisToken.string(nameSpace), RedisToken.string(table),
				RedisToken.string(key));
	}

	/**
	 * 提交通知请求
	 * 
	 * @param respClient
	 * @param callback
	 * @param params
	 * @return
	 */
	public static RedisToken expire(RespClient respClient, RedisToken params) {
		Callable<RedisToken> runnable = new Callable<RedisToken>() {
			public RedisToken call() {
				try {
					respClient.send(params);
				} catch (Exception e) {
					log.error("PING-->request happen error,see :{} ", e);
					return string("EXPIRE_ERROR");
				}
				return string("EXPIRE_SUCCESS");
			}
		};
		return submit(runnable, respNotifyService, RespNodesHelper.TIME_OUT);
	}

}
