package com.cache.resp.service.expire;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.github.tonivade.resp.RespCallback;
import com.github.tonivade.resp.protocol.RedisToken;

/**
 * 过期通知服务callback
 * 
 * @author dongjianlei
 *
 */
public class BaseRespExpireCallBack implements RespCallback {

	protected static final Logger log = LoggerFactory.getLogger(BaseRespExpireCallBack.class);

	protected static final String EXPIRE = "EXPIRE";

	public BaseRespExpireCallBack() {
		super();
	}

	/**
	 *
	 * @param expire
	 */
	@Override
	public void onMessage(RedisToken expire) {
		if (RedisToken.RESPONSE_OK.toString().equals(expire.toString())) {
			log.info("Key desynchronization is succeeded By RESP ...");
		}
	}

	@Override
	public void onConnect() {
	}

	@Override
	public void onDisconnect() {
	}
}
