package com.cache.resp.service.alive;

import static com.github.tonivade.resp.protocol.RedisToken.array;
import static com.github.tonivade.resp.protocol.RedisToken.string;

import java.util.ArrayList;
import java.util.Map.Entry;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;

import org.apache.commons.lang3.StringUtils;

import com.cache.redis.util.ObjectUtil;
import com.cache.resp.status.RespStatus;
import com.cache.resp.task.RespAliveTask;
import com.cache.resp.thread.RespThreadFactory;
import com.cache.resp.utils.RespNodesHelper;
import com.cache.resp.utils.ServerHelper;
import com.github.tonivade.resp.RespClient;
import com.github.tonivade.resp.protocol.RedisToken;

/**
 * 节点信息沟通服务
 *
 * @author dongjianlei
 */
public class RespAliveService extends BaseRespAliveService {

	private static final String ALIVE_DESC = "Cache-resp-alive-";

	private static AtomicBoolean STARTER = new AtomicBoolean(false);

	private static AtomicBoolean INIT = new AtomicBoolean(false);

	private static ExecutorService respAliveService;

	private RespAliveService() {
	}

	private static class SingletonInner {
		private static RespAliveService respAliveService = new RespAliveService();
	}

	/**
	 * 线程最大数量根据节点数减1，一个节点分配一个线程
	 */
	public static RespAliveService getInstance(String nodes) {
		if (INIT.compareAndSet(false, true) && (!StringUtils.isEmpty(nodes) && nodes.split(",").length - 1 > 0)) {
			respAliveService = newCachedThreadPool(nodes.split(",").length - 1, new RespThreadFactory(ALIVE_DESC));
		}
		return SingletonInner.respAliveService;
	}

	public static RespAliveService getInstance() {
		return SingletonInner.respAliveService;
	}

	private static ExecutorService newCachedThreadPool(int threadNum, ThreadFactory factory) {
		return Executors.newFixedThreadPool(threadNum, factory);
	}

	/**
	 * 初始化 当前节点对集群其他节点的通信服务
	 */
	public void start(Long aliveInterval) {
		if (STARTER.compareAndSet(false, true)) {
			if (!ObjectUtil.isEmpty(respClients)) {
				for (Entry<String, RespClient> entry : respClients.entrySet()) {
					entry.getValue().start();
					log.info("Now resp client service is started, server ip is :{}  ", entry.getKey());
				}
				initRespStatus();
			}
			new Thread(new RespAliveTask(aliveInterval)).start();
		}
	}

	public static RedisToken ping(RespClient respClient) {
		Callable<RedisToken> runnable = new Callable<RedisToken>() {
			public RedisToken call() {
				try {
					respClient.send(array(string(PING)));
				} catch (Exception e) {
					log.error("PING-->request happen error,see :{} ", e);
					return string("ERROR");
				}
				return string("SUCCESS");
			}
		};
		return submit(runnable, respAliveService, RespNodesHelper.TIME_OUT);
	}

	/**
	 * 初始化集群节点状态
	 *
	 * @return
	 */
	private static RespStatus initRespStatus() {
		if (respStatus == null) {
			respStatus = new RespStatus();
			respStatus.setCurrentNode(ServerHelper.getInstance().getServerHost());
			respStatus.setOrtherNodes(new ArrayList<String>(respClients.keySet()));
		}
		return respStatus;
	}

}
