package com.cache.resp.service.alive;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.cache.resp.factory.RespClientFactory;
import com.cache.resp.service.RespService;
import com.github.tonivade.resp.RespCallback;
import com.github.tonivade.resp.RespClient;

/**
 * resp基础服务实现
 * 
 * @author dongjianlei
 *
 */
public abstract class BaseRespAliveService extends BaseRespAliveCallBack implements RespService {

	protected static final Logger log = LoggerFactory.getLogger(BaseRespAliveService.class);

	protected static Map<String, RespClient> respClients = RespClientFactory.getRespClients();

	protected static Map<String, RespCallback> callbacks = RespClientFactory.getCallback();

	public static <T> T submit(Callable<T> call, ExecutorService respService, long timeOut) {
		Future<T> result = respService.submit(call);
		T t = null;
		try {
			t = result.get(timeOut, TimeUnit.MILLISECONDS);
		} catch (InterruptedException e) {
			Thread.currentThread().interrupt();
			log.error("respService get result happen InterruptedException..see :{}", e);
		} catch (TimeoutException e) {
			log.error("respService get result happen TimeoutException..see :{}", e);
		} catch (ExecutionException e) {
			log.error("respService get result happen ExecutionException..see :{}", e);
		}
		return t;
	}

}
