package com.cache.resp.service.alive;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.cache.resp.status.RespStatus;
import com.github.tonivade.resp.RespCallback;
import com.github.tonivade.resp.protocol.RedisToken;

/**
 * 探活服务callback
 * 
 * @author dongjianlei
 *
 */
public class BaseRespAliveCallBack implements RespCallback {

	protected static final Logger log = LoggerFactory.getLogger(BaseRespAliveCallBack.class);

	protected static final String PING = "PING";
	protected static final String PONG = "PONG";
	public static final String SEPARATOR = "_";
	/** 本集群其他节点的状态 **/
	public static RespStatus respStatus;
	/** ping 请求返回结果,带有时间戳标识 **/
	public static Map<Integer, String> pingFlags = new ConcurrentHashMap<>(64);

	public BaseRespAliveCallBack() {
		super();
		pingFlags.put(this.hashCode(), System.currentTimeMillis() + SEPARATOR + false);
	}

	/**
	 * 根据探活结果进行节点状态判断
	 */
	@Override
	public void onMessage(RedisToken pong) {
		if (RedisToken.status(PONG).toString().equals(pong.toString())) {
			pingFlags.put(this.hashCode(), System.currentTimeMillis() + SEPARATOR + true);
		} else {
			pingFlags.put(this.hashCode(), System.currentTimeMillis() + SEPARATOR + false);
		}
	}

	@Override
	public void onConnect() {
	}

	@Override
	public void onDisconnect() {
	}
}
