package com.cache.resp.factory;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

import com.cache.redis.util.ObjectUtil;
import com.cache.resp.command.LocalCommandSuite;
import com.cache.resp.utils.RespNodesHelper;
import com.cache.resp.utils.ServerHelper;
import com.github.tonivade.resp.RespServer;
import com.github.tonivade.resp.RespServerContext;
import com.github.tonivade.resp.command.CommandSuite;

import redis.clients.jedis.HostAndPort;

/**
 * resp 服务类
 * 
 * @author dongjianlei
 *
 */
public class RespServerFactory {

	/*** 当前节点的 Resp 服务 **/
	private static RespServer respServer;

	private static AtomicBoolean STARTER = new AtomicBoolean(false);

	static CommandSuite commandSuite;

	private RespServerFactory() {
	}

	public static RespServerFactory getInstance() {
		return SingletonInner.respServerFactory;
	}

	private static class SingletonInner {
		private static RespServerFactory respServerFactory = new RespServerFactory();
	}

	/**
	 * server 启动
	 */
	public void startRespServer(String nodes) {
		if (respServer == null && STARTER.compareAndSet(false, true)) {
			respServer = initRespServer(nodes);
		}
		if (respServer != null && STARTER.get()) {
			respServer.start();
		}
	}

	/**
	 * server 关闭
	 */
	public static void shutRespServer() {
		if (respServer != null) {
			respServer.stop();
		}
	}

	/**
	 * 构建当前节点的resp服务
	 * 
	 * @return
	 */
	private static RespServer initRespServer(String nodes) {

		String serverHost = ServerHelper.getInstance().getServerHost();
		List<HostAndPort> formatNodes = RespNodesHelper.formatNodes(nodes);
		if (!ObjectUtil.isEmpty(formatNodes)) {
			List<HostAndPort> filterHost = formatNodes.stream().filter(h -> h.getHost().equals(serverHost))
					.collect(Collectors.toList());
			if (!ObjectUtil.isEmpty(filterHost)) {
				respServer = new RespServer(
						new RespServerContext(serverHost, filterHost.get(0).getPort(), careteCommandSuite()));
				return respServer;
			}
		}
		return null;
	}

	private static synchronized CommandSuite careteCommandSuite() {
		if (commandSuite == null) {
			commandSuite = new LocalCommandSuite();
		}
		return commandSuite;
	}

	public static CommandSuite getCommandSuite() {
		return careteCommandSuite();
	}

	public static RespServer getRespServer() {
		return respServer;
	}

}
