package com.cache.resp.factory;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.cache.redis.util.ObjectUtil;
import com.cache.resp.service.alive.BaseRespAliveCallBack;
import com.cache.resp.utils.RespNodesHelper;
import com.cache.resp.utils.ServerHelper;
import com.github.tonivade.resp.RespCallback;
import com.github.tonivade.resp.RespClient;

import redis.clients.jedis.HostAndPort;

/**
 * resp 客户端
 * 
 * @author dongjianlei
 *
 */
public class RespClientFactory {
	private static final Logger log = LoggerFactory.getLogger(RespClientFactory.class);

	/*** 当前节点对集群其他节点的 Resp客户端 服务 **/
	public static Map<String, RespClient> respClients = new ConcurrentHashMap<>(64);

	private static Map<String, RespCallback> callbacks = new ConcurrentHashMap<>(64);

	private static AtomicBoolean STARTER = new AtomicBoolean(false);

	private RespClientFactory() {
	}

	private static class SingletonInner {
		private static RespClientFactory respClientFactory = new RespClientFactory();
	}

	public static RespClientFactory getInstance() {
		return SingletonInner.respClientFactory;
	}

	/**
	 * 构建当前节点对集群其他节点的的resp客户端连接
	 * 
	 * @return
	 */
	public void initRespClients(String nodes) {
		if (STARTER.compareAndSet(false, true)) {
			String serverHost = ServerHelper.getInstance().getServerHost();
			List<HostAndPort> formatNodes = RespNodesHelper.formatNodes(nodes);
			if (!ObjectUtil.isEmpty(formatNodes)) {
				List<HostAndPort> filterHost = formatNodes.stream().filter(h -> !h.getHost().equals(serverHost))
						.collect(Collectors.toList());
				if (!ObjectUtil.isEmpty(filterHost)) {
					for (HostAndPort hostAndPort : filterHost) {
						RespCallback respCallback = new BaseRespAliveCallBack();
						RespClient redisClient = new RespClient(hostAndPort.getHost(), hostAndPort.getPort(),
								respCallback);
						respClients.put(hostAndPort.getHost(), redisClient);
						callbacks.put(hostAndPort.getHost(), respCallback);
					}
					log.info("RespClients  are created,see: {}", respClients);
				}
			}
		}

	}

	public static Map<String, RespClient> getRespClients() {
		return respClients;
	}

	public static Map<String, RespCallback> getCallback() {
		return callbacks;
	}
}
