package com.cache.resp.command;

import static com.github.tonivade.resp.protocol.RedisToken.status;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.cache.exception.CacheException;
import com.cache.resp.task.RespExpireTask;
import com.github.tonivade.resp.annotation.Command;
import com.github.tonivade.resp.annotation.ParamLength;
import com.github.tonivade.resp.command.Request;
import com.github.tonivade.resp.command.RespCommand;
import com.github.tonivade.resp.protocol.RedisToken;

@Command("expire")
@ParamLength(3)
public class ExpireCommand implements RespCommand {
	private static final Logger log = LoggerFactory.getLogger(ExpireCommand.class);
	private static final String EXPIRED = "EXPIRED";
	public static final String EXPIRE = "EXPIRE";
	private static final String ERROR = "ERROR";

	@Override
	public RedisToken execute(Request request) {
		if (request.getLength() > 0) {
			try {
				RespExpireTask.getInstance().delete(request);
			} catch (CacheException e) {
				log.error("del key  by Guava happen error ,see:{}", e);
				return status(ERROR);
			}
			return RedisToken.responseOk();
		} else {
			return status(EXPIRED);
		}
	}
}