package com.cache.extension.loader;

import java.util.Map;
import java.util.Map.Entry;

import javax.annotation.PostConstruct;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;


import com.cache.extension.ann.ICacheHandler;
import com.cache.redis.handelr.CacheHandler;
import com.cache.redis.handelr.factory.CacheHandlerFactory;
import com.cache.redis.util.ObjectUtil;

/**
 * 通过spring 的方式 加载 ：使用了CacheHandler注解并且实现了 CacheHandler接口 的拦截器实现类
 * 
 * @author dongjianlei
 * @date 2020年12月24日
 */
@Component
public class CacheHandlesLoader implements ApplicationContextAware {

	private static final Logger logger = LoggerFactory.getLogger(CacheHandlesLoader.class);

	private ApplicationContext applicationContext;

	@PostConstruct
	public void getCacheSubmitInterceptorAnnotation() {
		Map<Integer, CacheHandler> cacheHandlers = CacheHandlerFactory.cacheHandlers;
		Map<String, Object> cacheHandlerMap = applicationContext.getBeansWithAnnotation(ICacheHandler.class);
		if (!ObjectUtil.isEmpty(cacheHandlerMap)) {
			for (Entry<String, Object> entry : cacheHandlerMap.entrySet()) {
				if (!(entry.getValue() instanceof ICacheHandler)) {
					continue;
				}
				CacheHandler cacheHandler = (CacheHandler) entry.getValue();
				ICacheHandler handler = cacheHandler.getClass().getAnnotation(ICacheHandler.class);
				cacheHandlers.put(handler.order(), cacheHandler);
			}
			logger.info("CacheHandlers init ready ,see :{} .", cacheHandlers);
		}
	}

	@Override
	public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
		this.applicationContext = applicationContext;
	}

	public ApplicationContext getApplicationContext() {
		return applicationContext;
	}
}
