package com.cache.extension.ann;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.springframework.stereotype.Component;

/**
 * Cache handler 注解
 * 
 * @author dongjianlei
 * @date 2020年12月24日
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Component
public @interface ICacheHandler {
	/**
	 * handler名称,需有意义,可以表达handler的作用
	 * 
	 * @return
	 */
	String name() default "";

	/**
	 * handler执行顺序，值越小，优先级越高<br/>
	 * (tenant) 多租户拦截器 使用默认值
	 * 
	 * @return
	 */
	int order() default 100;

}
