/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tracing;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.codingapi.txlcn.common.util.Maps;
import com.codingapi.txlcn.common.util.id.RandomUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class TracingContext {
    private static final Logger log = LoggerFactory.getLogger(TracingContext.class);
    private static ThreadLocal<TracingContext> tracingContextThreadLocal = new ThreadLocal();
    private Map<String, String> fields;

    private TracingContext() {
    }

    public static TracingContext tracing() {
        if (tracingContextThreadLocal.get() == null) {
            tracingContextThreadLocal.set(new TracingContext());
        }
        return tracingContextThreadLocal.get();
    }

    public void beginTransactionGroup() {
        if (this.hasGroup()) {
            return;
        }
        TracingContext.init(Maps.newHashMap((Object)"groupId", (Object)RandomUtils.randomKey(), (Object)"appMap", (Object)"{}"));
    }

    public static void init(Map<String, String> initFields) {
        if (Objects.isNull(initFields)) {
            log.warn("init tracingContext fail. null init fields.");
            return;
        }
        TracingContext tracingContext = TracingContext.tracing();
        if (Objects.isNull(tracingContext.fields)) {
            tracingContext.fields = new HashMap<String, String>();
        }
        tracingContext.fields.putAll(initFields);
    }

    public boolean hasGroup() {
        return Objects.nonNull(this.fields) && this.fields.containsKey("groupId") && StringUtils.hasText((String)this.fields.get("groupId"));
    }

    public String groupId() {
        if (this.hasGroup()) {
            return this.fields.get("groupId");
        }
        this.raiseNonGroupException();
        return "";
    }

    public Map<String, String> fields() {
        return this.fields;
    }

    public void addApp(String serviceId, String address) {
        if (this.hasGroup()) {
            JSONObject map = JSON.parseObject((String)this.fields.get("appMap"));
            if (map.containsKey((Object)serviceId)) {
                return;
            }
            map.put(serviceId, (Object)address);
            this.fields.put("appMap", JSON.toJSONString((Object)map));
            return;
        }
        this.raiseNonGroupException();
    }

    public JSONObject appMap() {
        return JSON.parseObject((String)this.appMapString());
    }

    public String appMapString() {
        if (this.hasGroup()) {
            String appMap = Optional.ofNullable(this.fields.get("appMap")).orElse("");
            log.debug("App map: {}", (Object)appMap);
            return appMap;
        }
        this.raiseNonGroupException();
        return "{}";
    }

    public void destroy() {
        if (Objects.nonNull(tracingContextThreadLocal.get())) {
            tracingContextThreadLocal.remove();
        }
    }

    private void raiseNonGroupException() {
        throw new IllegalStateException("non group id.");
    }
}

