/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.common.util.id;

import com.codingapi.txlcn.common.util.id.IdGen;

public class DefaultIdGen
implements IdGen {
    private static final long START_TIME = 1548992829394L;
    private long machineId;
    private int machineOffset;
    private long seq;
    private int seqLen;
    private long lastTime;

    public DefaultIdGen(int seqLen, long machineId) {
        this.seqLen = seqLen;
        this.machineOffset = seqLen;
        this.machineId = machineId;
    }

    @Override
    public synchronized String nextId() {
        long curTime = System.currentTimeMillis();
        if (curTime < this.lastTime) {
            throw new IllegalStateException("");
        }
        if (curTime == this.lastTime) {
            this.seq = this.seq + 1L & (long)(~(-1 << this.seqLen));
            if (this.seq == 0L) {
                curTime = this.tilNextMillis();
            }
        } else {
            this.seq = 0L;
        }
        this.lastTime = curTime;
        long seqWithMachine = this.machineId << this.machineOffset & Long.MAX_VALUE | this.seq;
        return Long.toHexString(curTime - 1548992829394L ^ 0x2537L) + Long.toHexString(seqWithMachine ^ 0x2537L);
    }

    private long tilNextMillis() {
        long newTime = System.currentTimeMillis();
        while (newTime <= this.lastTime) {
            newTime = System.currentTimeMillis();
        }
        return newTime;
    }
}

